# List all native packages providing dependencies of the given package.
# USAGE: dependencies_full_list_packages $package
dependencies_full_list_packages() {
	local package
	package="$1"

	local \
		packages_list_legacy \
		packages_list_siblings \
		packages_list_commands \
		packages_list_libraries \
		packages_list_mono \
		packages_list_gstreamer
	packages_list_legacy=$(dependencies_legacy_list_packages "$package")
	packages_list_siblings=$(dependencies_siblings_list_packages "$package")
	packages_list_commands=$(dependencies_commands_list_packages "$package")
	packages_list_libraries=$(dependencies_libraries_list_packages "$package")
	packages_list_mono=$(dependencies_mono_list_packages "$package")
	packages_list_gstreamer=$(dependencies_gstreamer_list_packages "$package")
	## TODO: Some games would benefit from the ability to set dependencies on fonts.

	local packages_list_full
	packages_list_full="
	$packages_list_legacy
	$packages_list_siblings
	$packages_list_commands
	$packages_list_libraries
	$packages_list_mono
	$packages_list_gstreamer"

	printf '%s' "$packages_list_full" | list_clean
}

