/*************************************************************************************
 *  Copyright (C) 2010-2012 by Percy Camilo T. Aucahuasi <percy.camilo.ta@gmail.com> *
 *                                                                                   *
 *  This program is free software; you can redistribute it and/or                    *
 *  modify it under the terms of the GNU General Public License                      *
 *  as published by the Free Software Foundation; either version 2                   *
 *  of the License, or (at your option) any later version.                           *
 *                                                                                   *
 *  This program is distributed in the hope that it will be useful,                  *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of                   *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                    *
 *  GNU General Public License for more details.                                     *
 *                                                                                   *
 *  You should have received a copy of the GNU General Public License                *
 *  along with this program; if not, write to the Free Software                      *
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA   *
 *************************************************************************************/


#include "private/abstractsurface.h"
// #include "private/surfacefactory.h"
#include "private/functiongraphfactory.h"

#include <analitza/value.h>
#include <analitza/vector.h>
#include <QVector3D>

using namespace Analitza;

//TODO below is a macros for the prop e

//NOTE 
//FUTURE
//TODO GSOC Equipotential Curve -> Contour Plot: can be achieved by separating the type
// of surface e.g. a surface generated by a f (a, b) contains isolines ...
// in this way, it is possible to have a function f (a, b, c, d) and draw their
// contourplot3d. This is the proposal:
// class SurfaceByFunctionOfTwoVars change the name as appropriate
// {
//     ...
// public:
//     setISOCONTOURSValues(list of const values)
//     setISOCONTOURSVale(const value) -- a single value to which all the environments are equipotential
//     ...
// }
//

class  Fxy : public AbstractSurface/*, static class? better macros FooClass*/
{
public:
    CONSTRUCTORS(Fxy)
    TYPE_NAME(QT_TRANSLATE_NOOP("Function type", "Surface z=F(x,y)"))
    EXPRESSION_TYPE(Analitza::ExpressionType(Analitza::ExpressionType::Lambda).addParameter(
                        Analitza::ExpressionType(Analitza::ExpressionType::Value)).addParameter(
                        Analitza::ExpressionType(Analitza::ExpressionType::Value)).addParameter(
                        Analitza::ExpressionType(Analitza::ExpressionType::Value)))
    COORDDINATE_SYSTEM(Cartesian)
    PARAMETERS(QStringList(QStringLiteral("x")) << QStringLiteral("y"))
    ICON_NAME(QStringLiteral("newfunction3d"))
    EXAMPLES(QStringList(QStringLiteral("x*x+y")) << QStringLiteral("x+y*sin(x)") << QStringLiteral("x*y"))

    //Own

    QVector3D fromParametricArgs(double u, double v) override;
    void update(const QVector3D & oppositecorner1, const QVector3D & oppositecorner2) override;
};

QVector3D Fxy::fromParametricArgs(double u, double v)
{
    arg(QStringLiteral("x"))->setValue(u);
    arg(QStringLiteral("y"))->setValue(v);    
    
    return QVector3D(u,v,analyzer->calculateLambda().toReal().value());
}

void Fxy::update(const QVector3D & /*oppositecorner1*/, const QVector3D & /*oppositecorner2*/)
{
    buildParametricSurface();
//     vertices.clear();
//     normals.clear();
//     indices.clear();
// 
//     vertices << 0 << 0 << 0 << 0 << 0 << 1 << 1 << 0 << 0; // 3 for each index
//     normals << 0 << 1 << 0; // 1 by primitive = 1 by face (tri-face) -1 by every 3 index
//     indices << 0 << 1 << 2; // enumeration starts from scratch
}

REGISTER_SURFACE(Fxy)

class Fxz : public AbstractSurface/*, static class? better macros FooClass*/
{
public:
    CONSTRUCTORS(Fxz)
    TYPE_NAME(QT_TRANSLATE_NOOP("Function type", "Surface y=F(x,z)"))
    EXPRESSION_TYPE(Analitza::ExpressionType(Analitza::ExpressionType::Lambda).addParameter(
                        Analitza::ExpressionType(Analitza::ExpressionType::Value)).addParameter(
                        Analitza::ExpressionType(Analitza::ExpressionType::Value)).addParameter(
                        Analitza::ExpressionType(Analitza::ExpressionType::Value)))
    COORDDINATE_SYSTEM(Cartesian)
    PARAMETERS(QStringList(QStringLiteral("x")) << QStringLiteral("z"))
    ICON_NAME(QStringLiteral("newfunction3d"))
    EXAMPLES(QStringList(QStringLiteral("x+z")))

    QVector3D fromParametricArgs(double u, double v) override;
    void update(const QVector3D & oppositecorner1, const QVector3D & oppositecorner2) override;
};

QVector3D Fxz::fromParametricArgs(double u, double v)
{
    arg(QStringLiteral("x"))->setValue(u);
    arg(QStringLiteral("z"))->setValue(v);    
    
    return QVector3D(u,analyzer->calculateLambda().toReal().value(),v);
}

void Fxz::update(const QVector3D & /*oppositecorner1*/, const QVector3D & /*oppositecorner2*/)
{
    buildParametricSurface();
}

REGISTER_SURFACE(Fxz)

class Fyz : public AbstractSurface/*, static class? better macros FooClass*/
{
public:
    CONSTRUCTORS(Fyz)
    TYPE_NAME(QT_TRANSLATE_NOOP("Function type", "Surface x=F(y,z)"))
    EXPRESSION_TYPE(Analitza::ExpressionType(Analitza::ExpressionType::Lambda).addParameter(
                        Analitza::ExpressionType(Analitza::ExpressionType::Value)).addParameter(
                        Analitza::ExpressionType(Analitza::ExpressionType::Value)).addParameter(
                        Analitza::ExpressionType(Analitza::ExpressionType::Value)))
    COORDDINATE_SYSTEM(Cartesian)
    PARAMETERS(QStringList(QStringLiteral("y")) << QStringLiteral("z"))
    ICON_NAME(QStringLiteral("newfunction3d"))
    EXAMPLES(QStringList(QStringLiteral("y+z")))

    QVector3D fromParametricArgs(double u, double v) override;
    void update(const QVector3D & oppositecorner1, const QVector3D & oppositecorner2) override;
};

QVector3D Fyz::fromParametricArgs(double u, double v)
{
    arg(QStringLiteral("y"))->setValue(u);
    arg(QStringLiteral("z"))->setValue(v);    
    
    return QVector3D(u,analyzer->calculateLambda().toReal().value(),v);
}

void Fyz::update(const QVector3D & /*oppositecorner1*/, const QVector3D & /*oppositecorner2*/)
{
    buildParametricSurface();
}

REGISTER_SURFACE(Fyz)
