/*
 * Doubly-linked list classes and templates
 * Implementation file
 * $Id: dlist.cc,v 1.1 2003/03/13 01:13:41 hsteoh Exp hsteoh $
 */

#include <dlist.h>


/* FUNCTION DEFINITIONS */

// Note: this does NOT recursively destruct the linked list chain. The
// list class is responsible for that.
_dlistnode::~_dlistnode() {}

void _dlistbase::clear() {
  _dlistnode *n, *next;

  for (n=head; n; n=next) {
    next = n->next;
    delete n;
  }
  head = tail = 0;
  count = 0;
}

void _dlistbase::insert(_dlistnode *n, _dlistnode *succ)  {
  // Link to new successor
  n->next = succ;
  if (succ) {
    n->prev = succ->prev;
    succ->prev = n;
  } else {
    n->prev = tail;
    tail = n;
  }

  // Link to new predecessor
  if (n->prev) {
    n->prev->next = n;
  } else {
    head = n;
  }
  count++;				// add new node to count
}

_dlistnode *_dlistbase::remove(_dlistnode *n) {
  if (n->prev) {
    n->prev->next = n->next;
  } else {
    head = n->next;
  }
  if (n->next) {
    n->next->prev = n->prev;
  } else {
    tail = n->prev;
  }
  n->next = n->prev = 0;		// clean up removed node (just in case)
  count--;				// update node count
  return n;
}

