#define XERR "memoryaccess"
#include "memoryaccess.ih"

    // by get.cc

void MemoryAccess::activate(size_t blockIdx, int id)
{
    size_t &usedIdx = s_loaded[d_idx];
    int &blockId = d_block[blockIdx];

    if (usedIdx != s_noBlock)    // there is an active idx
    {
        if (id == d_block[usedIdx])  // already loaded
            return;                 // ready to continue

        disconnect(usedIdx);
    }

    blockId = id;                   // d_block[blockIdx] received the ID of
                                    // the requested shared memory block.

    usedIdx = blockIdx;             // set s_loaded[d_idx] to the block's 
                                    // index 

    setDataPtr(id);                 // d_data points to the shared memory 
                                    // block
}
