################################################################################
#
#  IPACCT FlashOS BUILD SYSTEM
#
#  $Id: bpfmon.mk,v 1.14 2020/09/30 21:50:18 bbonev Exp $
#
#
BPFMON_DIR:=$(BUILD_DIR)/bpfmon

BPFMON_BINS:=/usr/bin/bpfmon
BPFMON_BINS+=/usr/bin/psort

BINS_/usr/bin/bpfmon:=bpfmon
BINS_/usr/bin/psort:=psort

$(BPFMON_DIR)/.configured:
	@mkdir -p $(BPFMON_DIR)
	touch $(BPFMON_DIR)/.configured

$(BPFMON_DIR)/.built.bpfmon: $(BPFMON_DIR)/.configured $(FLASHOSDIR)/package/bpfmon/bpfmon.c
	$(CC) $(TARGET_CFLAGS) -O3 -std=gnu89 -flto -I$(STAGING_DIR)/usr/include -I$(FLASHOSDIR)/package/bpfmon -o $(BPFMON_DIR)/bpfmon $(FLASHOSDIR)/package/bpfmon/bpfmon.c -L$(STAGING_DIR)/usr/lib -lyascreen -lpcap -lnl-genl-3 -lnl-3 -lnl-route-3
	touch $(BPFMON_DIR)/.built.bpfmon

$(BPFMON_DIR)/.built.psort: $(BPFMON_DIR)/.configured $(FLASHOSDIR)/package/bpfmon/psort.c
	$(CC) $(TARGET_CFLAGS) -O3 -std=gnu89 -flto -I$(STAGING_DIR)/usr/include -I$(FLASHOSDIR)/package/bpfmon -o $(BPFMON_DIR)/psort $(FLASHOSDIR)/package/bpfmon/psort.c -L$(STAGING_DIR)/usr/lib -lyascreen -lpcap -lnl-genl-3 -lnl-3 -lnl-route-3
	touch $(BPFMON_DIR)/.built.psort

$(BPFMON_DIR)/.built: $(BPFMON_DIR)/.built.bpfmon $(BPFMON_DIR)/.built.psort
	touch $(BPFMON_DIR)/.built

bpfmon: libpcap yascreen $(BPFMON_DIR)/.built

$(eval $(call BINS,bpfmon,$(BPFMON_BINS),$(BPFMON_DIR)))

TARGETS+=bpfmon
