
Notable changes in 0.29 as compared to 0.28.1
=============================================

May require attention
---------------------

* The minimum Python version is now to 2.6.

* The index format has been adjusted to handle a larger number of
  entries, which will trigger a full index rebuild on the next index
  update, making that run more expensive than usual.

* The `gc` command should now clean up its temporary bloom filters,
  but filters created by earlier invocations may still exist in your
  repositories in the objects/pack/ directory as tmp-gc-*.bloom files,
  It should be safe to delete these files when no bup commands are
  running.

General
-------

* Some Python 2.6 compatibility problems have been fixed.

* `index` runs may be much less expensive for parts of the filesystem
  that haven't changed since the last save.

* An experimental `prune-older` command has been added.  It removes
  (permanently deletes) all saves except those preserved by a set of
  arguments like `--keep-monthlies-for 3y`.  See `bup help
  prune-older` for further information.

* `gc` should now only require up to one packfile (about 1GB) of
  temporary space while running.  Previously it might require much
  more.

* `gc` should read much less data now, which may make it notably
  faster.

* The `gc` `--threshold` argument should actually be allowed now.

* `gc` should be able to handle deeper filesystem trees without
  crashing.  Previously it was constrained by the default Python stack
  depth limit.

* `save` and `split` should reject invalid `-n` names immediately
  instead of waiting until after their work is complete.

* bup should no longer crash when trying to fsync on an SMB
  filesystem under OS X.

* `save` and `restore` should work on ntfs-3g filesystems now.  Previously
  they might crash when trying to manipulate file attrs.

Build system
------------

* The web tests should be skipped if tornado is not detected.

* The fuse tests should be skipped if the fuse module is not detected.

* `make clean` should work better on non-Linux systems.


Thanks to (at least)
====================

Andrew Skretvedt, Ben Kelly, Bruno Bigras, Greg Troxel, Jacob Edelman,
Jonathan Wright, Julien Sanchez, Mark J Hewitt, Nick Alcock, Pascal
Honoré, Rob Browning, Wayne Scott, axion, ilovezfs, phillipproell, and
vi0oss
