/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.maven.doxia.parser.module;

/**
 * Provides definitions for a Doxia Parser module. This is used by the Doxia Site Tools to find which
 * Doxia modules can parse files, and where to find these files by default (directory and extension).
 *
 * @since 1.6
 */
public interface ParserModule {
    /**
     * Returns the directory that contains source files for a given module.
     *
     * @return The source directory.
     */
    String getSourceDirectory();

    /**
     * Returns the supported file extensions for a given module.
     *
     * @return The supported file extensions.
     * @since 1.7 (was String getExtension() before)
     */
    String[] getExtensions();

    /**
     * Returns the parser id for a given module.
     *
     * @return The parser id.
     */
    String getParserId();
}
