e2tools development notes
=========================

This file contains a few notes for developers contributing to `e2tools`.


Source code standards
=====================

To be determined for e2tools:

   * C language standard
   * C standard library requirements
   * C sourcecode formatting rules


Release checklist
=================

This checklist outlines some basics for tagging a release on
Github. Update the list when you run into and solved issues, such as
how to properly release "make dist" generated tarballs using Github.

  * Is the `AUTHORS` file up to date?

  * Does the `NEWS.md` summarize all user visible changes?

  * Does `configure.ac` `AC_INIT` contain the correct version number?

  * Does the first line of `NEWS.md` contain the correct version number?

  * Does `make clean && make check` run?

  * Does `make distcheck` run?

  * Do the `git commit` and `git push` to the master branch on github.

  * Wait for Travis CI to finish building successfully. If the build
    fails, investigate and fix the problem.

  * Enjoy the [github releases web
    interface](https://github.com/e2tools/e2tools/releases):

      * Tag `e2tools` release `1.2.3` as `v1.2.3` beginning with the `v`.

      * Summarize the changes since the last release in the release
        notes, formatting it properly usign Github flavoured
        Markdown. `NEWS.md` will come in handy here.

      * Upload the release tarball generated by `make distcheck`
        attaching it to the Github release.

      * Update the https://e2tools.github.io/ web page to point at the
        Github release.
