/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import net.sourceforge.pmd.IRuleViolation;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.renderers.OnTheFlyRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextRenderer
extends OnTheFlyRenderer {
    private boolean empty;

    @Override
    public void start() throws IOException {
        this.empty = true;
    }

    @Override
    public void renderFileViolations(Iterator<IRuleViolation> violations) throws IOException {
        Writer writer = this.getWriter();
        StringBuffer buf = new StringBuffer();
        boolean bl = this.empty = !violations.hasNext();
        while (violations.hasNext()) {
            buf.setLength(0);
            IRuleViolation rv = violations.next();
            buf.append(PMD.EOL).append(rv.getFilename());
            buf.append(':').append(Integer.toString(rv.getBeginLine()));
            buf.append('\t').append(rv.getDescription());
            writer.write(buf.toString());
        }
    }

    @Override
    public void end() throws IOException {
        Writer writer = this.getWriter();
        StringBuffer buf = new StringBuffer();
        if (!this.errors.isEmpty()) {
            this.empty = false;
            for (Report.ProcessingError error : this.errors) {
                buf.setLength(0);
                buf.append(PMD.EOL).append(error.getFile());
                buf.append("\t-\t").append(error.getMsg());
                writer.write(buf.toString());
            }
        }
        for (Report.SuppressedViolation excluded : this.suppressed) {
            buf.setLength(0);
            buf.append(PMD.EOL);
            buf.append(excluded.getRuleViolation().getRule().getName());
            buf.append(" rule violation suppressed by ");
            buf.append(excluded.suppressedByNOPMD() ? "//NOPMD" : "Annotation");
            buf.append(" in ").append(excluded.getRuleViolation().getFilename());
            writer.write(buf.toString());
        }
        if (this.empty) {
            this.getWriter().write("No problems found!");
        }
    }
}

