/*
 * Decompiled with CFR 0.152.
 */
package com.sqlmagic.tinysql;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class Utils {
    static final String encode = "Cp1252";
    static final boolean debug = false;

    public static final byte[] intToLittleEndian(int n) {
        byte[] byArray = new byte[4];
        int n2 = 0;
        while (n2 < 4) {
            byArray[n2] = (byte)(n % 256);
            n /= 256;
            ++n2;
        }
        return byArray;
    }

    public static final byte[] shortToLittleEndian(short s) {
        byte[] byArray = new byte[2];
        int n = 0;
        while (n < 2) {
            byArray[n] = (byte)(s % 256);
            s = (short)(s / 256);
            ++n;
        }
        return byArray;
    }

    public static final double vax_to_long(byte[] byArray) {
        long l = 0xFFL & (long)byArray[0] | (0xFFL & (long)byArray[1]) << 8 | (0xFFL & (long)byArray[2]) << 16 | (0xFFL & (long)byArray[3]) << 24;
        return l;
    }

    public static final int vax_to_short(byte[] byArray) {
        return Utils.fixByte(byArray[0]) + Utils.fixByte(byArray[1]) * 256;
    }

    public static final short fixByte(byte by) {
        if (by < 0) {
            return (short)(by + 256);
        }
        return by;
    }

    public static final String forceToSize(String string, int n, String string2) {
        if (string != null && string.length() == n) {
            return string;
        }
        StringBuffer stringBuffer = string == null ? new StringBuffer(n) : new StringBuffer(string);
        if (stringBuffer.length() > n) {
            return stringBuffer.toString().substring(0, n);
        }
        StringBuffer stringBuffer2 = new StringBuffer(n);
        int n2 = n - stringBuffer.length();
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer2.append(string2);
            ++n3;
        }
        return stringBuffer.append((Object)stringBuffer2).toString();
    }

    public static final byte[] forceToSize(String string, int n, byte by) throws UnsupportedEncodingException {
        if (string != null && string.length() == n) {
            return string.getBytes(encode);
        }
        byte[] byArray = new byte[n];
        if (string == null) {
            int n2 = 0;
            while (n2 < n) {
                byArray[n2] = by;
                ++n2;
            }
            return byArray;
        }
        if (string.length() > n) {
            return string.substring(0, n).getBytes(encode);
        }
        byte[] byArray2 = string.getBytes(encode);
        int n3 = 0;
        while (n3 < byArray2.length) {
            byArray[n3] = byArray2[n3];
            ++n3;
        }
        int n4 = byArray2.length;
        while (n4 < n) {
            byArray[n4] = by;
            ++n4;
        }
        return byArray;
    }

    public static final void delFile(String string) throws NullPointerException, IOException {
        File file = new File(string);
        if (file.exists() && !file.delete()) {
            throw new IOException("Could not delete: " + file.getAbsolutePath() + ".");
        }
    }

    public static final void delFile(String string, String string2) throws NullPointerException, IOException {
        File file = new File(string + File.separator + string2);
        if (file.exists() && !file.delete()) {
            throw new IOException("Could not delete file: " + string + "/" + string2 + ".");
        }
    }

    public static final boolean renameFile(String string, String string2) {
        File file = new File(string);
        File file2 = new File(string2);
        boolean bl = file.renameTo(file2);
        return bl;
    }

    public static final String stripPathAndExtension(String string) {
        String string2 = File.separator;
        int n = string.lastIndexOf(string2);
        n = n < 0 ? 0 : ++n;
        int n2 = string.lastIndexOf(".");
        if (n2 < 0) {
            n2 = string.length();
        }
        String string3 = string.substring(n, n2);
        return string3;
    }

    public static final Vector getAllFiles(String string, String string2) {
        Vector<File> vector = null;
        String string3 = string2.toUpperCase();
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray == null) {
            System.out.println("*** null for " + string);
        } else {
            vector = new Vector<File>(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                String string4;
                File file2 = new File(stringArray[n]);
                if (!file2.isDirectory() && string3 == null | (string4 = file2.getPath().toString().toUpperCase()).endsWith(string3)) {
                    vector.addElement(file2);
                }
                ++n;
            }
        }
        return vector;
    }

    public static boolean isDateColumn(int n) {
        return n == 91 | n == 93;
    }

    public static boolean isCharColumn(int n) {
        return n == 1 | n == 12 | n == -1;
    }

    public static boolean isNumberColumn(int n) {
        return n == 2 | n == 4 | n == -6 | n == 5 | n == -5 | n == 6 | n == 8 | n == 7;
    }

    public static boolean isFunctionName(String string) {
        String[] stringArray = new String[]{"COUNT", "SUM", "MIN", "MAX", "UPPER", "TRIM", "SUBSTR", "CONCAT", "TO_DATE"};
        int n = 0;
        while (n < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean endsWithFunctionName(String string) {
        String[] stringArray = new String[]{"COUNT", "SUM", "MIN", "MAX", "UPPER", "TRIM", "SUBSTR", "CONCAT", "TO_DATE"};
        String string2 = string.toUpperCase();
        int n = 0;
        while (n < stringArray.length) {
            if (string2.endsWith(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean clearFunction(String string) {
        String[] stringArray = new String[]{"UPPER", "TRIM", "SUBSTR"};
        int n = 0;
        while (n < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static void setPriority(Vector vector, String string) {
        if (vector == (Vector)null) {
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            String string2 = (String)vector.elementAt(n);
            if (string2.equals(string)) {
                if (n <= 0) break;
                vector.removeElementAt(n);
                vector.insertElementAt(string2, 0);
                break;
            }
            ++n;
        }
    }

    static final void log(String string, String string2) {
    }

    static final void log(String string) {
    }
}

