# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=btver2 -all-views       < %s | FileCheck %s -check-prefixes=DEFAULTREPORT,FULLREPORT
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=btver2 -all-views=true  < %s | FileCheck %s -check-prefixes=DEFAULTREPORT,FULLREPORT
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=btver2 -all-views=false < %s | FileCheck %s -check-prefix=NOREPORT -allow-empty
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=btver2                  < %s | FileCheck %s -check-prefix=DEFAULTREPORT

add %eax, %eax

# NOREPORT-NOT: {{.}}

# DEFAULTREPORT:      Iterations:        100
# DEFAULTREPORT-NEXT: Instructions:      100
# DEFAULTREPORT-NEXT: Total Cycles:      103
# DEFAULTREPORT-NEXT: Total uOps:        100

# DEFAULTREPORT:      Dispatch Width:    2
# DEFAULTREPORT-NEXT: uOps Per Cycle:    0.97
# DEFAULTREPORT-NEXT: IPC:               0.97
# DEFAULTREPORT-NEXT: Block RThroughput: 0.5

# FULLREPORT:         Cycles with backend pressure increase [ 76.70% ]
# FULLREPORT-NEXT:    Throughput Bottlenecks:
# FULLREPORT-NEXT:      Resource Pressure       [ 0.00% ]
# FULLREPORT-NEXT:      Data Dependencies:      [ 76.70% ]
# FULLREPORT-NEXT:      - Register Dependencies [ 76.70% ]
# FULLREPORT-NEXT:      - Memory Dependencies   [ 0.00% ]

# FULLREPORT:         Critical sequence based on the simulation:

# FULLREPORT:                       Instruction                                 Dependency Information
# FULLREPORT-NEXT:     +----< 0.    addl	%eax, %eax
# FULLREPORT-NEXT:     |
# FULLREPORT-NEXT:     |    < loop carried >
# FULLREPORT-NEXT:     |
# FULLREPORT-NEXT:     +----> 0.    addl	%eax, %eax                        ## REGISTER dependency:  %eax
# FULLREPORT-NEXT:     |
# FULLREPORT-NEXT:     |    < loop carried >
# FULLREPORT-NEXT:     |
# FULLREPORT-NEXT:     +----> 0.    addl	%eax, %eax                        ## REGISTER dependency:  %eax

# DEFAULTREPORT:      Instruction Info:
# DEFAULTREPORT-NEXT: [1]: #uOps
# DEFAULTREPORT-NEXT: [2]: Latency
# DEFAULTREPORT-NEXT: [3]: RThroughput
# DEFAULTREPORT-NEXT: [4]: MayLoad
# DEFAULTREPORT-NEXT: [5]: MayStore
# DEFAULTREPORT-NEXT: [6]: HasSideEffects (U)

# DEFAULTREPORT:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# DEFAULTREPORT-NEXT:  1      1     0.50                        addl	%eax, %eax

# FULLREPORT:         Dynamic Dispatch Stall Cycles:
# FULLREPORT-NEXT:    RAT     - Register unavailable:                      0
# FULLREPORT-NEXT:    RCU     - Retire tokens unavailable:                 0
# FULLREPORT-NEXT:    SCHEDQ  - Scheduler full:                            61  (59.2%)
# FULLREPORT-NEXT:    LQ      - Load queue full:                           0
# FULLREPORT-NEXT:    SQ      - Store queue full:                          0
# FULLREPORT-NEXT:    GROUP   - Static restrictions on the dispatch group: 0
# FULLREPORT-NEXT:    USH     - Uncategorised Structural Hazard:           0

# FULLREPORT:         Dispatch Logic - number of cycles where we saw N micro opcodes dispatched:
# FULLREPORT-NEXT:    [# dispatched], [# cycles]
# FULLREPORT-NEXT:     0,              22  (21.4%)
# FULLREPORT-NEXT:     1,              62  (60.2%)
# FULLREPORT-NEXT:     2,              19  (18.4%)

# FULLREPORT:         Schedulers - number of cycles where we saw N micro opcodes issued:
# FULLREPORT-NEXT:    [# issued], [# cycles]
# FULLREPORT-NEXT:     0,          3  (2.9%)
# FULLREPORT-NEXT:     1,          100  (97.1%)

# FULLREPORT:         Scheduler's queue usage:
# FULLREPORT-NEXT:    [1] Resource name.
# FULLREPORT-NEXT:    [2] Average number of used buffer entries.
# FULLREPORT-NEXT:    [3] Maximum number of used buffer entries.
# FULLREPORT-NEXT:    [4] Total number of buffer entries.

# FULLREPORT:          [1]            [2]        [3]        [4]
# FULLREPORT-NEXT:    JALU01           15         20         20
# FULLREPORT-NEXT:    JFPU01           0          0          18
# FULLREPORT-NEXT:    JLSAGU           0          0          12

# FULLREPORT:         Retire Control Unit - number of cycles where we saw N instructions retired:
# FULLREPORT-NEXT:    [# retired], [# cycles]
# FULLREPORT-NEXT:     0,           3  (2.9%)
# FULLREPORT-NEXT:     1,           100  (97.1%)

# FULLREPORT:         Total ROB Entries:                64
# FULLREPORT-NEXT:    Max Used ROB Entries:             22  ( 34.4% )
# FULLREPORT-NEXT:    Average Used ROB Entries per cy:  17  ( 26.6% )

# FULLREPORT:         Register File statistics:
# FULLREPORT-NEXT:    Total number of mappings created:    200
# FULLREPORT-NEXT:    Max number of mappings used:         44

# FULLREPORT:         *  Register File #1 -- JFpuPRF:
# FULLREPORT-NEXT:       Number of physical registers:     72
# FULLREPORT-NEXT:       Total number of mappings created: 0
# FULLREPORT-NEXT:       Max number of mappings used:      0

# FULLREPORT:         *  Register File #2 -- JIntegerPRF:
# FULLREPORT-NEXT:       Number of physical registers:     64
# FULLREPORT-NEXT:       Total number of mappings created: 200
# FULLREPORT-NEXT:       Max number of mappings used:      44

# DEFAULTREPORT:      Resources:
# DEFAULTREPORT-NEXT: [0]   - JALU0
# DEFAULTREPORT-NEXT: [1]   - JALU1
# DEFAULTREPORT-NEXT: [2]   - JDiv
# DEFAULTREPORT-NEXT: [3]   - JFPA
# DEFAULTREPORT-NEXT: [4]   - JFPM
# DEFAULTREPORT-NEXT: [5]   - JFPU0
# DEFAULTREPORT-NEXT: [6]   - JFPU1
# DEFAULTREPORT-NEXT: [7]   - JLAGU
# DEFAULTREPORT-NEXT: [8]   - JMul
# DEFAULTREPORT-NEXT: [9]   - JSAGU
# DEFAULTREPORT-NEXT: [10]  - JSTC
# DEFAULTREPORT-NEXT: [11]  - JVALU0
# DEFAULTREPORT-NEXT: [12]  - JVALU1
# DEFAULTREPORT-NEXT: [13]  - JVIMUL

# DEFAULTREPORT:      Resource pressure per iteration:
# DEFAULTREPORT-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12]   [13]
# DEFAULTREPORT-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -      -      -

# DEFAULTREPORT:      Resource pressure by instruction:
# DEFAULTREPORT-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12]   [13]   Instructions:
# DEFAULTREPORT-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -      -      -     addl	%eax, %eax

# FULLREPORT:         Timeline view:
# FULLREPORT-NEXT:                        012
# FULLREPORT-NEXT:    Index     0123456789

# FULLREPORT:         [0,0]     DeER .    . .   addl	%eax, %eax
# FULLREPORT-NEXT:    [1,0]     D=eER.    . .   addl	%eax, %eax
# FULLREPORT-NEXT:    [2,0]     .D=eER    . .   addl	%eax, %eax
# FULLREPORT-NEXT:    [3,0]     .D==eER   . .   addl	%eax, %eax
# FULLREPORT-NEXT:    [4,0]     . D==eER  . .   addl	%eax, %eax
# FULLREPORT-NEXT:    [5,0]     . D===eER . .   addl	%eax, %eax
# FULLREPORT-NEXT:    [6,0]     .  D===eER. .   addl	%eax, %eax
# FULLREPORT-NEXT:    [7,0]     .  D====eER .   addl	%eax, %eax
# FULLREPORT-NEXT:    [8,0]     .   D====eER.   addl	%eax, %eax
# FULLREPORT-NEXT:    [9,0]     .   D=====eER   addl	%eax, %eax

# FULLREPORT:         Average Wait times (based on the timeline view):
# FULLREPORT-NEXT:    [0]: Executions
# FULLREPORT-NEXT:    [1]: Average time spent waiting in a scheduler's queue
# FULLREPORT-NEXT:    [2]: Average time spent waiting in a scheduler's queue while ready
# FULLREPORT-NEXT:    [3]: Average time elapsed from WB until retire stage

# FULLREPORT:               [0]    [1]    [2]    [3]
# FULLREPORT-NEXT:    0.     10    3.5    0.1    0.0       addl	%eax, %eax
