/*
 * Copyright (C) 2020 Linux Studio Plugins Project <https://lsp-plug.in/>
 *           (C) 2020 Vladimir Sadovnikov <sadko4u@gmail.com>
 *
 * This file is part of lsp-plugins
 * Created on: 06 окт. 2015 г.
 *
 * lsp-plugins is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * lsp-plugins is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with lsp-plugins. If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef PLUGINS_PLUGINS_H_
#define PLUGINS_PLUGINS_H_

#include <core/debug.h>
#include <core/plugin.h>

// List of plugins
#include <plugins/phase_detector.h>
#include <plugins/comp_delay.h>
#include <plugins/spectrum_analyzer.h>
#include <plugins/sampler.h>
#include <plugins/trigger.h>
#include <plugins/para_equalizer.h>
#include <plugins/graph_equalizer.h>
#include <plugins/compressor.h>
#include <plugins/dyna_processor.h>
#include <plugins/expander.h>
#include <plugins/gate.h>
#include <plugins/limiter.h>
#include <plugins/impulse_responses.h>
#include <plugins/impulse_reverb.h>
#include <plugins/slap_delay.h>
#include <plugins/oscillator.h>
#include <plugins/latency_meter.h>
#include <plugins/mb_compressor.h>
#include <plugins/profiler.h>
#include <plugins/room_builder.h>
#include <plugins/mb_expander.h>
#include <plugins/mb_gate.h>
#include <plugins/loud_comp.h>
#include <plugins/surge_filter.h>
#include <plugins/crossover.h>
#include <plugins/art_delay.h>

#include <plugins/nonlinear_convolver.h>

#include <plugins/experimental.h>


#endif /* PLUGINS_PLUGINS_H_ */
