/* readonlycollection.c generated by valac 0.56.17, the Vala compiler
 * generated from readonlycollection.vala, do not modify */

/* readonlycollection.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 * Copyright (C) 2010-2014  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib-object.h>
#include "gee.h"
#include <glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GEE_TYPE_READ_ONLY_COLLECTION (gee_read_only_collection_get_type ())
#define GEE_READ_ONLY_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_READ_ONLY_COLLECTION, GeeReadOnlyCollection))
#define GEE_READ_ONLY_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_READ_ONLY_COLLECTION, GeeReadOnlyCollectionClass))
#define GEE_IS_READ_ONLY_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_READ_ONLY_COLLECTION))
#define GEE_IS_READ_ONLY_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_READ_ONLY_COLLECTION))
#define GEE_READ_ONLY_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_READ_ONLY_COLLECTION, GeeReadOnlyCollectionClass))

typedef struct _GeeReadOnlyCollection GeeReadOnlyCollection;
typedef struct _GeeReadOnlyCollectionClass GeeReadOnlyCollectionClass;
typedef struct _GeeReadOnlyCollectionPrivate GeeReadOnlyCollectionPrivate;
enum  {
	GEE_READ_ONLY_COLLECTION_0_PROPERTY,
	GEE_READ_ONLY_COLLECTION_G_TYPE,
	GEE_READ_ONLY_COLLECTION_G_DUP_FUNC,
	GEE_READ_ONLY_COLLECTION_G_DESTROY_FUNC,
	GEE_READ_ONLY_COLLECTION_SIZE_PROPERTY,
	GEE_READ_ONLY_COLLECTION_READ_ONLY_PROPERTY,
	GEE_READ_ONLY_COLLECTION_READ_ONLY_VIEW_PROPERTY,
	GEE_READ_ONLY_COLLECTION_NUM_PROPERTIES
};
static GParamSpec* gee_read_only_collection_properties[GEE_READ_ONLY_COLLECTION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GEE_READ_ONLY_COLLECTION_TYPE_ITERATOR (gee_read_only_collection_iterator_get_type ())
#define GEE_READ_ONLY_COLLECTION_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_READ_ONLY_COLLECTION_TYPE_ITERATOR, GeeReadOnlyCollectionIterator))
#define GEE_READ_ONLY_COLLECTION_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_READ_ONLY_COLLECTION_TYPE_ITERATOR, GeeReadOnlyCollectionIteratorClass))
#define GEE_READ_ONLY_COLLECTION_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_READ_ONLY_COLLECTION_TYPE_ITERATOR))
#define GEE_READ_ONLY_COLLECTION_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_READ_ONLY_COLLECTION_TYPE_ITERATOR))
#define GEE_READ_ONLY_COLLECTION_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_READ_ONLY_COLLECTION_TYPE_ITERATOR, GeeReadOnlyCollectionIteratorClass))

typedef struct _GeeReadOnlyCollectionIterator GeeReadOnlyCollectionIterator;
typedef struct _GeeReadOnlyCollectionIteratorClass GeeReadOnlyCollectionIteratorClass;
typedef struct _GeeReadOnlyCollectionIteratorPrivate GeeReadOnlyCollectionIteratorPrivate;
enum  {
	GEE_READ_ONLY_COLLECTION_ITERATOR_0_PROPERTY,
	GEE_READ_ONLY_COLLECTION_ITERATOR_G_TYPE,
	GEE_READ_ONLY_COLLECTION_ITERATOR_G_DUP_FUNC,
	GEE_READ_ONLY_COLLECTION_ITERATOR_G_DESTROY_FUNC,
	GEE_READ_ONLY_COLLECTION_ITERATOR_VALID_PROPERTY,
	GEE_READ_ONLY_COLLECTION_ITERATOR_READ_ONLY_PROPERTY,
	GEE_READ_ONLY_COLLECTION_ITERATOR_NUM_PROPERTIES
};
static GParamSpec* gee_read_only_collection_iterator_properties[GEE_READ_ONLY_COLLECTION_ITERATOR_NUM_PROPERTIES];

struct _GeeReadOnlyCollection {
	GObject parent_instance;
	GeeReadOnlyCollectionPrivate * priv;
	GeeCollection* _collection;
};

struct _GeeReadOnlyCollectionClass {
	GObjectClass parent_class;
	GeeCollection* (*get_read_only_view) (GeeReadOnlyCollection* self);
};

struct _GeeReadOnlyCollectionPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};

struct _GeeReadOnlyCollectionIterator {
	GObject parent_instance;
	GeeReadOnlyCollectionIteratorPrivate * priv;
	GeeIterator* _iter;
};

struct _GeeReadOnlyCollectionIteratorClass {
	GObjectClass parent_class;
};

struct _GeeReadOnlyCollectionIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};

static gint GeeReadOnlyCollection_private_offset;
static gpointer gee_read_only_collection_parent_class = NULL;
static gint GeeReadOnlyCollectionIterator_private_offset;
static gpointer gee_read_only_collection_iterator_parent_class = NULL;
static GeeTraversableIface * gee_read_only_collection_iterator_gee_traversable_parent_iface = NULL;
static GeeIteratorIface * gee_read_only_collection_iterator_gee_iterator_parent_iface = NULL;
static GeeTraversableIface * gee_read_only_collection_gee_traversable_parent_iface = NULL;
static GeeIterableIface * gee_read_only_collection_gee_iterable_parent_iface = NULL;
static GeeCollectionIface * gee_read_only_collection_gee_collection_parent_iface = NULL;

 G_GNUC_INTERNAL GType gee_read_only_collection_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
 G_GNUC_INTERNAL GeeCollection* gee_read_only_collection_get_read_only_view (GeeReadOnlyCollection* self);
 G_GNUC_INTERNAL GeeReadOnlyCollection* gee_read_only_collection_new (GType g_type,
                                                     GBoxedCopyFunc g_dup_func,
                                                     GDestroyNotify g_destroy_func,
                                                     GeeCollection* collection);
 G_GNUC_INTERNAL GeeReadOnlyCollection* gee_read_only_collection_construct (GType object_type,
                                                           GType g_type,
                                                           GBoxedCopyFunc g_dup_func,
                                                           GDestroyNotify g_destroy_func,
                                                           GeeCollection* collection);
static gboolean gee_read_only_collection_real_foreach (GeeTraversable* base,
                                                GeeForallFunc f,
                                                gpointer f_target);
static GeeIterator* gee_read_only_collection_real_stream (GeeTraversable* base,
                                                   GType a_type,
                                                   GBoxedCopyFunc a_dup_func,
                                                   GDestroyNotify a_destroy_func,
                                                   GeeStreamFunc f,
                                                   gpointer f_target,
                                                   GDestroyNotify f_target_destroy_notify);
static GeeIterator* gee_read_only_collection_real_filter (GeeTraversable* base,
                                                   GeePredicate f,
                                                   gpointer f_target,
                                                   GDestroyNotify f_target_destroy_notify);
static GeeIterator* gee_read_only_collection_real_chop (GeeTraversable* base,
                                                 gint offset,
                                                 gint length);
static GeeIterator* gee_read_only_collection_real_iterator (GeeIterable* base);
 G_GNUC_INTERNAL GeeReadOnlyCollectionIterator* gee_read_only_collection_iterator_new (GType g_type,
                                                                      GBoxedCopyFunc g_dup_func,
                                                                      GDestroyNotify g_destroy_func,
                                                                      GeeIterator* iterator);
 G_GNUC_INTERNAL GeeReadOnlyCollectionIterator* gee_read_only_collection_iterator_construct (GType object_type,
                                                                            GType g_type,
                                                                            GBoxedCopyFunc g_dup_func,
                                                                            GDestroyNotify g_destroy_func,
                                                                            GeeIterator* iterator);
VALA_EXTERN GType gee_read_only_collection_iterator_get_type (void) G_GNUC_CONST ;
static gboolean gee_read_only_collection_real_contains (GeeCollection* base,
                                                 gconstpointer item);
static gboolean gee_read_only_collection_real_add (GeeCollection* base,
                                            gconstpointer item);
static gboolean gee_read_only_collection_real_remove (GeeCollection* base,
                                               gconstpointer item);
static void gee_read_only_collection_real_clear (GeeCollection* base);
static gboolean gee_read_only_collection_real_add_all (GeeCollection* base,
                                                GeeCollection* collection);
static gboolean gee_read_only_collection_real_contains_all (GeeCollection* base,
                                                     GeeCollection* collection);
static gboolean gee_read_only_collection_real_remove_all (GeeCollection* base,
                                                   GeeCollection* collection);
static gboolean gee_read_only_collection_real_retain_all (GeeCollection* base,
                                                   GeeCollection* collection);
static gpointer* gee_read_only_collection_real_to_array (GeeCollection* base,
                                                  gint* result_length1);
static gboolean gee_read_only_collection_iterator_real_next (GeeIterator* base);
static gboolean gee_read_only_collection_iterator_real_has_next (GeeIterator* base);
static gpointer gee_read_only_collection_iterator_real_get (GeeIterator* base);
static void gee_read_only_collection_iterator_real_remove (GeeIterator* base);
static gboolean gee_read_only_collection_iterator_real_foreach (GeeTraversable* base,
                                                         GeeForallFunc f,
                                                         gpointer f_target);
static GeeIterator* gee_read_only_collection_iterator_real_stream (GeeTraversable* base,
                                                            GType a_type,
                                                            GBoxedCopyFunc a_dup_func,
                                                            GDestroyNotify a_destroy_func,
                                                            GeeStreamFunc f,
                                                            gpointer f_target,
                                                            GDestroyNotify f_target_destroy_notify);
static GeeIterator* gee_read_only_collection_iterator_real_filter (GeeTraversable* base,
                                                            GeePredicate f,
                                                            gpointer f_target,
                                                            GDestroyNotify f_target_destroy_notify);
static GeeIterator* gee_read_only_collection_iterator_real_chop (GeeTraversable* base,
                                                          gint offset,
                                                          gint length);
static GeeIterator** gee_read_only_collection_iterator_real_tee (GeeTraversable* base,
                                                          guint forks,
                                                          gint* result_length1);
static void gee_read_only_collection_iterator_finalize (GObject * obj);
static GType gee_read_only_collection_iterator_get_type_once (void);
static void _vala_gee_read_only_collection_iterator_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec);
static void _vala_gee_read_only_collection_iterator_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec);
static void gee_read_only_collection_finalize (GObject * obj);
static GType gee_read_only_collection_get_type_once (void);
static void _vala_gee_read_only_collection_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_gee_read_only_collection_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
gee_read_only_collection_get_instance_private (GeeReadOnlyCollection* self)
{
	return G_STRUCT_MEMBER_P (self, GeeReadOnlyCollection_private_offset);
}

/**
 * Constructs a read-only collection that mirrors the content of the
 * specified collection.
 *
 * @param collection the collection to decorate.
 */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

 G_GNUC_INTERNAL GeeReadOnlyCollection*
gee_read_only_collection_construct (GType object_type,
                                    GType g_type,
                                    GBoxedCopyFunc g_dup_func,
                                    GDestroyNotify g_destroy_func,
                                    GeeCollection* collection)
{
	GeeReadOnlyCollection * self = NULL;
	GeeCollection* _tmp0_;
	g_return_val_if_fail (collection != NULL, NULL);
	self = (GeeReadOnlyCollection*) g_object_new (object_type, "g-type", g_type, "g-dup-func", g_dup_func, "g-destroy-func", g_destroy_func, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = _g_object_ref0 (collection);
	_g_object_unref0 (self->_collection);
	self->_collection = _tmp0_;
	return self;
}

 G_GNUC_INTERNAL GeeReadOnlyCollection*
gee_read_only_collection_new (GType g_type,
                              GBoxedCopyFunc g_dup_func,
                              GDestroyNotify g_destroy_func,
                              GeeCollection* collection)
{
	return gee_read_only_collection_construct (GEE_TYPE_READ_ONLY_COLLECTION, g_type, g_dup_func, g_destroy_func, collection);
}

/**
 * {@inheritDoc}
 */
static gboolean
gee_read_only_collection_real_foreach (GeeTraversable* base,
                                       GeeForallFunc f,
                                       gpointer f_target)
{
	GeeReadOnlyCollection * self;
	GeeCollection* _tmp0_;
	gboolean result;
	self = (GeeReadOnlyCollection*) base;
	_tmp0_ = self->_collection;
	result = gee_traversable_foreach ((GeeTraversable*) _tmp0_, f, f_target);
	return result;
}

/**
 * {@inheritDoc}
 */
static GeeIterator*
gee_read_only_collection_real_stream (GeeTraversable* base,
                                      GType a_type,
                                      GBoxedCopyFunc a_dup_func,
                                      GDestroyNotify a_destroy_func,
                                      GeeStreamFunc f,
                                      gpointer f_target,
                                      GDestroyNotify f_target_destroy_notify)
{
	GeeReadOnlyCollection * self;
	GeeCollection* _tmp0_;
	GeeStreamFunc _tmp1_;
	gpointer _tmp1__target;
	GDestroyNotify _tmp1__target_destroy_notify;
	GeeIterator* _tmp2_;
	GeeIterator* result;
	self = (GeeReadOnlyCollection*) base;
	_tmp0_ = self->_collection;
	_tmp1_ = f;
	_tmp1__target = f_target;
	_tmp1__target_destroy_notify = f_target_destroy_notify;
	f = NULL;
	f_target = NULL;
	f_target_destroy_notify = NULL;
	_tmp2_ = gee_traversable_stream ((GeeTraversable*) _tmp0_, a_type, (GBoxedCopyFunc) a_dup_func, (GDestroyNotify) a_destroy_func, _tmp1_, _tmp1__target, _tmp1__target_destroy_notify);
	result = _tmp2_;
	(f_target_destroy_notify == NULL) ? NULL : (f_target_destroy_notify (f_target), NULL);
	f = NULL;
	f_target = NULL;
	f_target_destroy_notify = NULL;
	return result;
}

/**
 * {@inheritDoc}
 */
static GeeIterator*
gee_read_only_collection_real_filter (GeeTraversable* base,
                                      GeePredicate f,
                                      gpointer f_target,
                                      GDestroyNotify f_target_destroy_notify)
{
	GeeReadOnlyCollection * self;
	GeeCollection* _tmp0_;
	GeePredicate _tmp1_;
	gpointer _tmp1__target;
	GDestroyNotify _tmp1__target_destroy_notify;
	GeeIterator* _tmp2_;
	GeeIterator* result;
	self = (GeeReadOnlyCollection*) base;
	_tmp0_ = self->_collection;
	_tmp1_ = f;
	_tmp1__target = f_target;
	_tmp1__target_destroy_notify = f_target_destroy_notify;
	f = NULL;
	f_target = NULL;
	f_target_destroy_notify = NULL;
	_tmp2_ = gee_traversable_filter ((GeeTraversable*) _tmp0_, _tmp1_, _tmp1__target, _tmp1__target_destroy_notify);
	result = _tmp2_;
	(f_target_destroy_notify == NULL) ? NULL : (f_target_destroy_notify (f_target), NULL);
	f = NULL;
	f_target = NULL;
	f_target_destroy_notify = NULL;
	return result;
}

/**
 * {@inheritDoc}
 */
static GeeIterator*
gee_read_only_collection_real_chop (GeeTraversable* base,
                                    gint offset,
                                    gint length)
{
	GeeReadOnlyCollection * self;
	GeeCollection* _tmp0_;
	GeeIterator* _tmp1_;
	GeeIterator* result;
	self = (GeeReadOnlyCollection*) base;
	_tmp0_ = self->_collection;
	_tmp1_ = gee_traversable_chop ((GeeTraversable*) _tmp0_, offset, length);
	result = _tmp1_;
	return result;
}

/**
 * {@inheritDoc}
 */
static GeeIterator*
gee_read_only_collection_real_iterator (GeeIterable* base)
{
	GeeReadOnlyCollection * self;
	GeeCollection* _tmp0_;
	GeeIterator* _tmp1_;
	GeeIterator* _tmp2_;
	GeeReadOnlyCollectionIterator* _tmp3_;
	GeeIterator* _tmp4_;
	GeeIterator* result;
	self = (GeeReadOnlyCollection*) base;
	_tmp0_ = self->_collection;
	_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_read_only_collection_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, _tmp2_);
	_tmp4_ = (GeeIterator*) _tmp3_;
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}

/**
 * {@inheritDoc}
 */
static gboolean
gee_read_only_collection_real_contains (GeeCollection* base,
                                        gconstpointer item)
{
	GeeReadOnlyCollection * self;
	GeeCollection* _tmp0_;
	gboolean result;
	self = (GeeReadOnlyCollection*) base;
	_tmp0_ = self->_collection;
	result = gee_collection_contains (_tmp0_, item);
	return result;
}

/**
 * Unimplemented method (read only collection).
 */
static gboolean
gee_read_only_collection_real_add (GeeCollection* base,
                                   gconstpointer item)
{
	GeeReadOnlyCollection * self;
	self = (GeeReadOnlyCollection*) base;
	g_assert_not_reached ();
}

/**
 * Unimplemented method (read only collection).
 */
static gboolean
gee_read_only_collection_real_remove (GeeCollection* base,
                                      gconstpointer item)
{
	GeeReadOnlyCollection * self;
	self = (GeeReadOnlyCollection*) base;
	g_assert_not_reached ();
}

/**
 * Unimplemented method (read only collection).
 */
static void
gee_read_only_collection_real_clear (GeeCollection* base)
{
	GeeReadOnlyCollection * self;
	self = (GeeReadOnlyCollection*) base;
	g_assert_not_reached ();
}

/**
 * Unimplemented method (read only collection).
 */
static gboolean
gee_read_only_collection_real_add_all (GeeCollection* base,
                                       GeeCollection* collection)
{
	GeeReadOnlyCollection * self;
	self = (GeeReadOnlyCollection*) base;
	g_return_val_if_fail (collection != NULL, FALSE);
	g_assert_not_reached ();
}

/**
 * {@inheritDoc}
 */
static gboolean
gee_read_only_collection_real_contains_all (GeeCollection* base,
                                            GeeCollection* collection)
{
	GeeReadOnlyCollection * self;
	GeeCollection* _tmp0_;
	gboolean result;
	self = (GeeReadOnlyCollection*) base;
	g_return_val_if_fail (collection != NULL, FALSE);
	_tmp0_ = self->_collection;
	result = gee_collection_contains_all (_tmp0_, collection);
	return result;
}

/**
 * Unimplemented method (read only collection).
 */
static gboolean
gee_read_only_collection_real_remove_all (GeeCollection* base,
                                          GeeCollection* collection)
{
	GeeReadOnlyCollection * self;
	self = (GeeReadOnlyCollection*) base;
	g_return_val_if_fail (collection != NULL, FALSE);
	g_assert_not_reached ();
}

/**
 * Unimplemented method (read only collection).
 */
static gboolean
gee_read_only_collection_real_retain_all (GeeCollection* base,
                                          GeeCollection* collection)
{
	GeeReadOnlyCollection * self;
	self = (GeeReadOnlyCollection*) base;
	g_return_val_if_fail (collection != NULL, FALSE);
	g_assert_not_reached ();
}

/**
 * {@inheritDoc}
 */
static gpointer*
gee_read_only_collection_real_to_array (GeeCollection* base,
                                        gint* result_length1)
{
	GeeReadOnlyCollection * self;
	GeeCollection* _tmp0_;
	gint _tmp1_ = 0;
	gpointer* _tmp2_;
	gpointer* _tmp3_;
	gint _tmp3__length1;
	gpointer* result;
	self = (GeeReadOnlyCollection*) base;
	_tmp0_ = self->_collection;
	_tmp2_ = gee_collection_to_array (_tmp0_, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp1_;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

static gint
gee_read_only_collection_real_get_size (GeeCollection* base)
{
	gint result;
	GeeReadOnlyCollection* self;
	GeeCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	self = (GeeReadOnlyCollection*) base;
	_tmp0_ = self->_collection;
	_tmp1_ = gee_collection_get_size (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static gboolean
gee_read_only_collection_real_get_is_empty (GeeCollection* base)
{
	gboolean result;
	GeeReadOnlyCollection* self;
	GeeCollection* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = (GeeReadOnlyCollection*) base;
	_tmp0_ = self->_collection;
	_tmp1_ = gee_collection_get_is_empty (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static gboolean
gee_read_only_collection_real_get_read_only (GeeCollection* base)
{
	gboolean result;
	GeeReadOnlyCollection* self;
	self = (GeeReadOnlyCollection*) base;
	result = TRUE;
	return result;
}

static GType
gee_read_only_collection_real_get_element_type (GeeTraversable* base)
{
	GType result;
	GeeReadOnlyCollection* self;
	self = (GeeReadOnlyCollection*) base;
	result = self->priv->g_type;
	return result;
}

 G_GNUC_INTERNAL GeeCollection*
gee_read_only_collection_get_read_only_view (GeeReadOnlyCollection* self)
{
	GeeReadOnlyCollectionClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = GEE_READ_ONLY_COLLECTION_GET_CLASS (self);
	if (_klass_->get_read_only_view) {
		return _klass_->get_read_only_view (self);
	}
	return NULL;
}

static GeeCollection*
gee_read_only_collection_real_get_read_only_view (GeeReadOnlyCollection* base)
{
	GeeCollection* result;
	GeeReadOnlyCollection* self;
	GeeCollection* _tmp0_;
	self = base;
	_tmp0_ = _g_object_ref0 ((GeeCollection*) self);
	result = _tmp0_;
	return result;
}

static inline gpointer
gee_read_only_collection_iterator_get_instance_private (GeeReadOnlyCollectionIterator* self)
{
	return G_STRUCT_MEMBER_P (self, GeeReadOnlyCollectionIterator_private_offset);
}

 G_GNUC_INTERNAL GeeReadOnlyCollectionIterator*
gee_read_only_collection_iterator_construct (GType object_type,
                                             GType g_type,
                                             GBoxedCopyFunc g_dup_func,
                                             GDestroyNotify g_destroy_func,
                                             GeeIterator* iterator)
{
	GeeReadOnlyCollectionIterator * self = NULL;
	GeeIterator* _tmp0_;
	g_return_val_if_fail (iterator != NULL, NULL);
	self = (GeeReadOnlyCollectionIterator*) g_object_new (object_type, "g-type", g_type, "g-dup-func", g_dup_func, "g-destroy-func", g_destroy_func, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = _g_object_ref0 (iterator);
	_g_object_unref0 (self->_iter);
	self->_iter = _tmp0_;
	return self;
}

 G_GNUC_INTERNAL GeeReadOnlyCollectionIterator*
gee_read_only_collection_iterator_new (GType g_type,
                                       GBoxedCopyFunc g_dup_func,
                                       GDestroyNotify g_destroy_func,
                                       GeeIterator* iterator)
{
	return gee_read_only_collection_iterator_construct (GEE_READ_ONLY_COLLECTION_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, iterator);
}

static gboolean
gee_read_only_collection_iterator_real_next (GeeIterator* base)
{
	GeeReadOnlyCollectionIterator * self;
	GeeIterator* _tmp0_;
	gboolean result;
	self = (GeeReadOnlyCollectionIterator*) base;
	_tmp0_ = self->_iter;
	result = gee_iterator_next (_tmp0_);
	return result;
}

static gboolean
gee_read_only_collection_iterator_real_has_next (GeeIterator* base)
{
	GeeReadOnlyCollectionIterator * self;
	GeeIterator* _tmp0_;
	gboolean result;
	self = (GeeReadOnlyCollectionIterator*) base;
	_tmp0_ = self->_iter;
	result = gee_iterator_has_next (_tmp0_);
	return result;
}

static gpointer
gee_read_only_collection_iterator_real_get (GeeIterator* base)
{
	GeeReadOnlyCollectionIterator * self;
	GeeIterator* _tmp0_;
	gpointer _tmp1_;
	gpointer result;
	self = (GeeReadOnlyCollectionIterator*) base;
	_tmp0_ = self->_iter;
	_tmp1_ = gee_iterator_get (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
gee_read_only_collection_iterator_real_remove (GeeIterator* base)
{
	GeeReadOnlyCollectionIterator * self;
	self = (GeeReadOnlyCollectionIterator*) base;
	g_assert_not_reached ();
}

static gboolean
gee_read_only_collection_iterator_real_foreach (GeeTraversable* base,
                                                GeeForallFunc f,
                                                gpointer f_target)
{
	GeeReadOnlyCollectionIterator * self;
	GeeIterator* _tmp0_;
	gboolean result;
	self = (GeeReadOnlyCollectionIterator*) base;
	_tmp0_ = self->_iter;
	result = gee_traversable_foreach ((GeeTraversable*) _tmp0_, f, f_target);
	return result;
}

static GeeIterator*
gee_read_only_collection_iterator_real_stream (GeeTraversable* base,
                                               GType a_type,
                                               GBoxedCopyFunc a_dup_func,
                                               GDestroyNotify a_destroy_func,
                                               GeeStreamFunc f,
                                               gpointer f_target,
                                               GDestroyNotify f_target_destroy_notify)
{
	GeeReadOnlyCollectionIterator * self;
	GeeIterator* _tmp0_;
	GeeStreamFunc _tmp1_;
	gpointer _tmp1__target;
	GDestroyNotify _tmp1__target_destroy_notify;
	GeeIterator* _tmp2_;
	GeeIterator* result;
	self = (GeeReadOnlyCollectionIterator*) base;
	_tmp0_ = self->_iter;
	_tmp1_ = f;
	_tmp1__target = f_target;
	_tmp1__target_destroy_notify = f_target_destroy_notify;
	f = NULL;
	f_target = NULL;
	f_target_destroy_notify = NULL;
	_tmp2_ = gee_traversable_stream ((GeeTraversable*) _tmp0_, a_type, (GBoxedCopyFunc) a_dup_func, (GDestroyNotify) a_destroy_func, _tmp1_, _tmp1__target, _tmp1__target_destroy_notify);
	result = _tmp2_;
	(f_target_destroy_notify == NULL) ? NULL : (f_target_destroy_notify (f_target), NULL);
	f = NULL;
	f_target = NULL;
	f_target_destroy_notify = NULL;
	return result;
}

static GeeIterator*
gee_read_only_collection_iterator_real_filter (GeeTraversable* base,
                                               GeePredicate f,
                                               gpointer f_target,
                                               GDestroyNotify f_target_destroy_notify)
{
	GeeReadOnlyCollectionIterator * self;
	GeeIterator* _tmp0_;
	GeePredicate _tmp1_;
	gpointer _tmp1__target;
	GDestroyNotify _tmp1__target_destroy_notify;
	GeeIterator* _tmp2_;
	GeeIterator* result;
	self = (GeeReadOnlyCollectionIterator*) base;
	_tmp0_ = self->_iter;
	_tmp1_ = f;
	_tmp1__target = f_target;
	_tmp1__target_destroy_notify = f_target_destroy_notify;
	f = NULL;
	f_target = NULL;
	f_target_destroy_notify = NULL;
	_tmp2_ = gee_traversable_filter ((GeeTraversable*) _tmp0_, _tmp1_, _tmp1__target, _tmp1__target_destroy_notify);
	result = _tmp2_;
	(f_target_destroy_notify == NULL) ? NULL : (f_target_destroy_notify (f_target), NULL);
	f = NULL;
	f_target = NULL;
	f_target_destroy_notify = NULL;
	return result;
}

static GeeIterator*
gee_read_only_collection_iterator_real_chop (GeeTraversable* base,
                                             gint offset,
                                             gint length)
{
	GeeReadOnlyCollectionIterator * self;
	GeeIterator* _tmp0_;
	GeeIterator* _tmp1_;
	GeeIterator* result;
	self = (GeeReadOnlyCollectionIterator*) base;
	_tmp0_ = self->_iter;
	_tmp1_ = gee_traversable_chop ((GeeTraversable*) _tmp0_, offset, length);
	result = _tmp1_;
	return result;
}

static GeeIterator**
gee_read_only_collection_iterator_real_tee (GeeTraversable* base,
                                            guint forks,
                                            gint* result_length1)
{
	GeeReadOnlyCollectionIterator * self;
	GeeIterator** result;
	self = (GeeReadOnlyCollectionIterator*) base;
	if (forks == ((guint) 0)) {
		GeeIterator** _tmp0_;
		GeeIterator** _tmp1_;
		gint _tmp1__length1;
		_tmp0_ = g_new0 (GeeIterator*, 0 + 1);
		_tmp1_ = _tmp0_;
		_tmp1__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp1__length1;
		}
		result = _tmp1_;
		return result;
	} else {
		GeeIterator** iters = NULL;
		GeeIterator* _tmp2_;
		gint _tmp3_ = 0;
		GeeIterator** _tmp4_;
		gint iters_length1;
		gint _iters_size_;
		GeeIterator** _result_ = NULL;
		GeeIterator** _tmp5_;
		gint _result__length1;
		gint __result__size_;
		GeeIterator** _tmp6_;
		gint _tmp6__length1;
		GeeIterator* _tmp7_;
		GeeIterator* _tmp8_;
		GeeIterator** _tmp21_;
		gint _tmp21__length1;
		_tmp2_ = self->_iter;
		_tmp4_ = gee_traversable_tee ((GeeTraversable*) _tmp2_, forks, &_tmp3_);
		iters = _tmp4_;
		iters_length1 = _tmp3_;
		_iters_size_ = iters_length1;
		_tmp5_ = g_new0 (GeeIterator*, forks + 1);
		_result_ = _tmp5_;
		_result__length1 = forks;
		__result__size_ = _result__length1;
		_tmp6_ = iters;
		_tmp6__length1 = iters_length1;
		_tmp7_ = _tmp6_[0];
		_tmp8_ = self->_iter;
		if (_tmp7_ == _tmp8_) {
			GeeIterator** _tmp9_;
			gint _tmp9__length1;
			GeeIterator* _tmp10_;
			_tmp9_ = _result_;
			_tmp9__length1 = _result__length1;
			_tmp10_ = _g_object_ref0 ((GeeIterator*) self);
			_g_object_unref0 (_tmp9_[0]);
			_tmp9_[0] = _tmp10_;
		} else {
			GeeIterator** _tmp11_;
			gint _tmp11__length1;
			GeeIterator** _tmp12_;
			gint _tmp12__length1;
			GeeIterator* _tmp13_;
			GeeReadOnlyCollectionIterator* _tmp14_;
			_tmp11_ = _result_;
			_tmp11__length1 = _result__length1;
			_tmp12_ = iters;
			_tmp12__length1 = iters_length1;
			_tmp13_ = _tmp12_[0];
			_tmp14_ = gee_read_only_collection_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, _tmp13_);
			_g_object_unref0 (_tmp11_[0]);
			_tmp11_[0] = (GeeIterator*) _tmp14_;
		}
		{
			guint i = 0U;
			i = (guint) 1;
			{
				gboolean _tmp15_ = FALSE;
				_tmp15_ = TRUE;
				while (TRUE) {
					GeeIterator** _tmp17_;
					gint _tmp17__length1;
					GeeIterator** _tmp18_;
					gint _tmp18__length1;
					GeeIterator* _tmp19_;
					GeeReadOnlyCollectionIterator* _tmp20_;
					if (!_tmp15_) {
						guint _tmp16_;
						_tmp16_ = i;
						i = _tmp16_ + 1;
					}
					_tmp15_ = FALSE;
					if (!(i < forks)) {
						break;
					}
					_tmp17_ = _result_;
					_tmp17__length1 = _result__length1;
					_tmp18_ = iters;
					_tmp18__length1 = iters_length1;
					_tmp19_ = _tmp18_[i];
					_tmp20_ = gee_read_only_collection_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, _tmp19_);
					_g_object_unref0 (_tmp17_[i]);
					_tmp17_[i] = (GeeIterator*) _tmp20_;
				}
			}
		}
		_tmp21_ = _result_;
		_tmp21__length1 = _result__length1;
		if (result_length1) {
			*result_length1 = _tmp21__length1;
		}
		result = _tmp21_;
		iters = (_vala_array_free (iters, iters_length1, (GDestroyNotify) g_object_unref), NULL);
		return result;
	}
}

static gboolean
gee_read_only_collection_iterator_real_get_valid (GeeIterator* base)
{
	gboolean result;
	GeeReadOnlyCollectionIterator* self;
	GeeIterator* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = (GeeReadOnlyCollectionIterator*) base;
	_tmp0_ = self->_iter;
	_tmp1_ = gee_iterator_get_valid (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static gboolean
gee_read_only_collection_iterator_real_get_read_only (GeeIterator* base)
{
	gboolean result;
	GeeReadOnlyCollectionIterator* self;
	self = (GeeReadOnlyCollectionIterator*) base;
	result = TRUE;
	return result;
}

static GType
gee_read_only_collection_iterator_real_get_element_type (GeeTraversable* base)
{
	GType result;
	GeeReadOnlyCollectionIterator* self;
	self = (GeeReadOnlyCollectionIterator*) base;
	result = self->priv->g_type;
	return result;
}

static void
gee_read_only_collection_iterator_class_init (GeeReadOnlyCollectionIteratorClass * klass,
                                              gpointer klass_data)
{
	gee_read_only_collection_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GeeReadOnlyCollectionIterator_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_read_only_collection_iterator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_read_only_collection_iterator_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_read_only_collection_iterator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_COLLECTION_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_COLLECTION_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_COLLECTION_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_COLLECTION_ITERATOR_VALID_PROPERTY, gee_read_only_collection_iterator_properties[GEE_READ_ONLY_COLLECTION_ITERATOR_VALID_PROPERTY] = g_param_spec_boolean ("valid", "valid", "valid", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_COLLECTION_ITERATOR_READ_ONLY_PROPERTY, gee_read_only_collection_iterator_properties[GEE_READ_ONLY_COLLECTION_ITERATOR_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static GType
gee_read_only_collection_iterator_gee_traversable_get_g_type (GeeReadOnlyCollectionIterator* self)
{
	return (GType) self->priv->g_type;
}

static GBoxedCopyFunc
gee_read_only_collection_iterator_gee_traversable_get_g_dup_func (GeeReadOnlyCollectionIterator* self)
{
	return (GBoxedCopyFunc) self->priv->g_dup_func;
}

static GDestroyNotify
gee_read_only_collection_iterator_gee_traversable_get_g_destroy_func (GeeReadOnlyCollectionIterator* self)
{
	return (GDestroyNotify) self->priv->g_destroy_func;
}

static void
gee_read_only_collection_iterator_gee_traversable_interface_init (GeeTraversableIface * iface,
                                                                  gpointer iface_data)
{
	gee_read_only_collection_iterator_gee_traversable_parent_iface = g_type_interface_peek_parent (iface);
	iface->foreach = (gboolean (*) (GeeTraversable*, GeeForallFunc, gpointer)) gee_read_only_collection_iterator_real_foreach;
	iface->stream = (GeeIterator* (*) (GeeTraversable*, GType, GBoxedCopyFunc, GDestroyNotify, GeeStreamFunc, gpointer, GDestroyNotify)) gee_read_only_collection_iterator_real_stream;
	iface->filter = (GeeIterator* (*) (GeeTraversable*, GeePredicate, gpointer, GDestroyNotify)) gee_read_only_collection_iterator_real_filter;
	iface->chop = (GeeIterator* (*) (GeeTraversable*, gint, gint)) gee_read_only_collection_iterator_real_chop;
	iface->tee = (GeeIterator** (*) (GeeTraversable*, guint, gint*)) gee_read_only_collection_iterator_real_tee;
	iface->get_g_type = (GType (*) (GeeTraversable *)) gee_read_only_collection_iterator_gee_traversable_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeTraversable *)) gee_read_only_collection_iterator_gee_traversable_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeTraversable *)) gee_read_only_collection_iterator_gee_traversable_get_g_destroy_func;
	iface->get_element_type = gee_read_only_collection_iterator_real_get_element_type;
}

static void
gee_read_only_collection_iterator_gee_iterator_interface_init (GeeIteratorIface * iface,
                                                               gpointer iface_data)
{
	gee_read_only_collection_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = (gboolean (*) (GeeIterator*)) gee_read_only_collection_iterator_real_next;
	iface->has_next = (gboolean (*) (GeeIterator*)) gee_read_only_collection_iterator_real_has_next;
	iface->get = (gpointer (*) (GeeIterator*)) gee_read_only_collection_iterator_real_get;
	iface->remove = (void (*) (GeeIterator*)) gee_read_only_collection_iterator_real_remove;
	iface->get_valid = gee_read_only_collection_iterator_real_get_valid;
	iface->get_read_only = gee_read_only_collection_iterator_real_get_read_only;
}

static void
gee_read_only_collection_iterator_instance_init (GeeReadOnlyCollectionIterator * self,
                                                 gpointer klass)
{
	self->priv = gee_read_only_collection_iterator_get_instance_private (self);
}

static void
gee_read_only_collection_iterator_finalize (GObject * obj)
{
	GeeReadOnlyCollectionIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_READ_ONLY_COLLECTION_TYPE_ITERATOR, GeeReadOnlyCollectionIterator);
	_g_object_unref0 (self->_iter);
	G_OBJECT_CLASS (gee_read_only_collection_iterator_parent_class)->finalize (obj);
}

static GType
gee_read_only_collection_iterator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GeeReadOnlyCollectionIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_read_only_collection_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeReadOnlyCollectionIterator), 0, (GInstanceInitFunc) gee_read_only_collection_iterator_instance_init, NULL };
	static const GInterfaceInfo gee_traversable_info = { (GInterfaceInitFunc) gee_read_only_collection_iterator_gee_traversable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_read_only_collection_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gee_read_only_collection_iterator_type_id;
	gee_read_only_collection_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeReadOnlyCollectionIterator", &g_define_type_info, 0);
	g_type_add_interface_static (gee_read_only_collection_iterator_type_id, GEE_TYPE_TRAVERSABLE, &gee_traversable_info);
	g_type_add_interface_static (gee_read_only_collection_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
	GeeReadOnlyCollectionIterator_private_offset = g_type_add_instance_private (gee_read_only_collection_iterator_type_id, sizeof (GeeReadOnlyCollectionIteratorPrivate));
	return gee_read_only_collection_iterator_type_id;
}

GType
gee_read_only_collection_iterator_get_type (void)
{
	static volatile gsize gee_read_only_collection_iterator_type_id__once = 0;
	if (g_once_init_enter (&gee_read_only_collection_iterator_type_id__once)) {
		GType gee_read_only_collection_iterator_type_id;
		gee_read_only_collection_iterator_type_id = gee_read_only_collection_iterator_get_type_once ();
		g_once_init_leave (&gee_read_only_collection_iterator_type_id__once, gee_read_only_collection_iterator_type_id);
	}
	return gee_read_only_collection_iterator_type_id__once;
}

static void
_vala_gee_read_only_collection_iterator_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec)
{
	GeeReadOnlyCollectionIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_READ_ONLY_COLLECTION_TYPE_ITERATOR, GeeReadOnlyCollectionIterator);
	switch (property_id) {
		case GEE_READ_ONLY_COLLECTION_ITERATOR_VALID_PROPERTY:
		g_value_set_boolean (value, gee_iterator_get_valid ((GeeIterator*) self));
		break;
		case GEE_READ_ONLY_COLLECTION_ITERATOR_READ_ONLY_PROPERTY:
		g_value_set_boolean (value, gee_iterator_get_read_only ((GeeIterator*) self));
		break;
		case GEE_READ_ONLY_COLLECTION_ITERATOR_G_TYPE:
		g_value_set_gtype (value, self->priv->g_type);
		break;
		case GEE_READ_ONLY_COLLECTION_ITERATOR_G_DUP_FUNC:
		g_value_set_pointer (value, self->priv->g_dup_func);
		break;
		case GEE_READ_ONLY_COLLECTION_ITERATOR_G_DESTROY_FUNC:
		g_value_set_pointer (value, self->priv->g_destroy_func);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gee_read_only_collection_iterator_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec)
{
	GeeReadOnlyCollectionIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_READ_ONLY_COLLECTION_TYPE_ITERATOR, GeeReadOnlyCollectionIterator);
	switch (property_id) {
		case GEE_READ_ONLY_COLLECTION_ITERATOR_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_READ_ONLY_COLLECTION_ITERATOR_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_READ_ONLY_COLLECTION_ITERATOR_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
gee_read_only_collection_class_init (GeeReadOnlyCollectionClass * klass,
                                     gpointer klass_data)
{
	gee_read_only_collection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GeeReadOnlyCollection_private_offset);
	GEE_READ_ONLY_COLLECTION_CLASS (klass)->get_read_only_view = (GeeCollection* (*) (GeeReadOnlyCollection*)) gee_read_only_collection_real_get_read_only_view;
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_read_only_collection_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_read_only_collection_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_read_only_collection_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_COLLECTION_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_COLLECTION_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_COLLECTION_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_COLLECTION_SIZE_PROPERTY, gee_read_only_collection_properties[GEE_READ_ONLY_COLLECTION_SIZE_PROPERTY] = g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_COLLECTION_READ_ONLY_PROPERTY, gee_read_only_collection_properties[GEE_READ_ONLY_COLLECTION_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_COLLECTION_READ_ONLY_VIEW_PROPERTY, gee_read_only_collection_properties[GEE_READ_ONLY_COLLECTION_READ_ONLY_VIEW_PROPERTY] = g_param_spec_object ("read-only-view", "read-only-view", "read-only-view", GEE_TYPE_COLLECTION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static GType
gee_read_only_collection_gee_traversable_get_g_type (GeeReadOnlyCollection* self)
{
	return (GType) self->priv->g_type;
}

static GBoxedCopyFunc
gee_read_only_collection_gee_traversable_get_g_dup_func (GeeReadOnlyCollection* self)
{
	return (GBoxedCopyFunc) self->priv->g_dup_func;
}

static GDestroyNotify
gee_read_only_collection_gee_traversable_get_g_destroy_func (GeeReadOnlyCollection* self)
{
	return (GDestroyNotify) self->priv->g_destroy_func;
}

static void
gee_read_only_collection_gee_traversable_interface_init (GeeTraversableIface * iface,
                                                         gpointer iface_data)
{
	gee_read_only_collection_gee_traversable_parent_iface = g_type_interface_peek_parent (iface);
	iface->foreach = (gboolean (*) (GeeTraversable*, GeeForallFunc, gpointer)) gee_read_only_collection_real_foreach;
	iface->stream = (GeeIterator* (*) (GeeTraversable*, GType, GBoxedCopyFunc, GDestroyNotify, GeeStreamFunc, gpointer, GDestroyNotify)) gee_read_only_collection_real_stream;
	iface->filter = (GeeIterator* (*) (GeeTraversable*, GeePredicate, gpointer, GDestroyNotify)) gee_read_only_collection_real_filter;
	iface->chop = (GeeIterator* (*) (GeeTraversable*, gint, gint)) gee_read_only_collection_real_chop;
	iface->get_g_type = (GType (*) (GeeTraversable *)) gee_read_only_collection_gee_traversable_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeTraversable *)) gee_read_only_collection_gee_traversable_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeTraversable *)) gee_read_only_collection_gee_traversable_get_g_destroy_func;
	iface->get_element_type = gee_read_only_collection_real_get_element_type;
}

static GType
gee_read_only_collection_gee_iterable_get_g_type (GeeReadOnlyCollection* self)
{
	return (GType) self->priv->g_type;
}

static GBoxedCopyFunc
gee_read_only_collection_gee_iterable_get_g_dup_func (GeeReadOnlyCollection* self)
{
	return (GBoxedCopyFunc) self->priv->g_dup_func;
}

static GDestroyNotify
gee_read_only_collection_gee_iterable_get_g_destroy_func (GeeReadOnlyCollection* self)
{
	return (GDestroyNotify) self->priv->g_destroy_func;
}

static void
gee_read_only_collection_gee_iterable_interface_init (GeeIterableIface * iface,
                                                      gpointer iface_data)
{
	gee_read_only_collection_gee_iterable_parent_iface = g_type_interface_peek_parent (iface);
	iface->iterator = (GeeIterator* (*) (GeeIterable*)) gee_read_only_collection_real_iterator;
	iface->get_g_type = (GType (*) (GeeIterable *)) gee_read_only_collection_gee_iterable_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeIterable *)) gee_read_only_collection_gee_iterable_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeIterable *)) gee_read_only_collection_gee_iterable_get_g_destroy_func;
}

static GType
gee_read_only_collection_gee_collection_get_g_type (GeeReadOnlyCollection* self)
{
	return (GType) self->priv->g_type;
}

static GBoxedCopyFunc
gee_read_only_collection_gee_collection_get_g_dup_func (GeeReadOnlyCollection* self)
{
	return (GBoxedCopyFunc) self->priv->g_dup_func;
}

static GDestroyNotify
gee_read_only_collection_gee_collection_get_g_destroy_func (GeeReadOnlyCollection* self)
{
	return (GDestroyNotify) self->priv->g_destroy_func;
}

static void
gee_read_only_collection_gee_collection_interface_init (GeeCollectionIface * iface,
                                                        gpointer iface_data)
{
	gee_read_only_collection_gee_collection_parent_iface = g_type_interface_peek_parent (iface);
	iface->contains = (gboolean (*) (GeeCollection*, gconstpointer)) gee_read_only_collection_real_contains;
	iface->add = (gboolean (*) (GeeCollection*, gconstpointer)) gee_read_only_collection_real_add;
	iface->remove = (gboolean (*) (GeeCollection*, gconstpointer)) gee_read_only_collection_real_remove;
	iface->clear = (void (*) (GeeCollection*)) gee_read_only_collection_real_clear;
	iface->add_all = (gboolean (*) (GeeCollection*, GeeCollection*)) gee_read_only_collection_real_add_all;
	iface->contains_all = (gboolean (*) (GeeCollection*, GeeCollection*)) gee_read_only_collection_real_contains_all;
	iface->remove_all = (gboolean (*) (GeeCollection*, GeeCollection*)) gee_read_only_collection_real_remove_all;
	iface->retain_all = (gboolean (*) (GeeCollection*, GeeCollection*)) gee_read_only_collection_real_retain_all;
	iface->to_array = (gpointer* (*) (GeeCollection*, gint*)) gee_read_only_collection_real_to_array;
	iface->get_g_type = (GType (*) (GeeCollection *)) gee_read_only_collection_gee_collection_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeCollection *)) gee_read_only_collection_gee_collection_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeCollection *)) gee_read_only_collection_gee_collection_get_g_destroy_func;
	iface->get_size = gee_read_only_collection_real_get_size;
	iface->get_is_empty = gee_read_only_collection_real_get_is_empty;
	iface->get_read_only = gee_read_only_collection_real_get_read_only;
	iface->get_read_only_view = (GeeCollection* (*) (GeeCollection*)) gee_read_only_collection_get_read_only_view;
}

static void
gee_read_only_collection_instance_init (GeeReadOnlyCollection * self,
                                        gpointer klass)
{
	self->priv = gee_read_only_collection_get_instance_private (self);
}

static void
gee_read_only_collection_finalize (GObject * obj)
{
	GeeReadOnlyCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_TYPE_READ_ONLY_COLLECTION, GeeReadOnlyCollection);
	_g_object_unref0 (self->_collection);
	G_OBJECT_CLASS (gee_read_only_collection_parent_class)->finalize (obj);
}

/**
 * Read-only view for {@link Collection} collections.
 *
 * This class decorates any class which implements the {@link Collection}
 * interface by making it read only. Any method which normally modify data will
 * throw an error.
 *
 * @see Collection
 */
static GType
gee_read_only_collection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GeeReadOnlyCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_read_only_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeReadOnlyCollection), 0, (GInstanceInitFunc) gee_read_only_collection_instance_init, NULL };
	static const GInterfaceInfo gee_traversable_info = { (GInterfaceInitFunc) gee_read_only_collection_gee_traversable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gee_iterable_info = { (GInterfaceInitFunc) gee_read_only_collection_gee_iterable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gee_collection_info = { (GInterfaceInitFunc) gee_read_only_collection_gee_collection_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gee_read_only_collection_type_id;
	gee_read_only_collection_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeReadOnlyCollection", &g_define_type_info, 0);
	g_type_add_interface_static (gee_read_only_collection_type_id, GEE_TYPE_TRAVERSABLE, &gee_traversable_info);
	g_type_add_interface_static (gee_read_only_collection_type_id, GEE_TYPE_ITERABLE, &gee_iterable_info);
	g_type_add_interface_static (gee_read_only_collection_type_id, GEE_TYPE_COLLECTION, &gee_collection_info);
	GeeReadOnlyCollection_private_offset = g_type_add_instance_private (gee_read_only_collection_type_id, sizeof (GeeReadOnlyCollectionPrivate));
	return gee_read_only_collection_type_id;
}

 G_GNUC_INTERNAL GType
gee_read_only_collection_get_type (void)
{
	static volatile gsize gee_read_only_collection_type_id__once = 0;
	if (g_once_init_enter (&gee_read_only_collection_type_id__once)) {
		GType gee_read_only_collection_type_id;
		gee_read_only_collection_type_id = gee_read_only_collection_get_type_once ();
		g_once_init_leave (&gee_read_only_collection_type_id__once, gee_read_only_collection_type_id);
	}
	return gee_read_only_collection_type_id__once;
}

static void
_vala_gee_read_only_collection_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	GeeReadOnlyCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_READ_ONLY_COLLECTION, GeeReadOnlyCollection);
	switch (property_id) {
		case GEE_READ_ONLY_COLLECTION_SIZE_PROPERTY:
		g_value_set_int (value, gee_collection_get_size ((GeeCollection*) self));
		break;
		case GEE_READ_ONLY_COLLECTION_READ_ONLY_PROPERTY:
		g_value_set_boolean (value, gee_collection_get_read_only ((GeeCollection*) self));
		break;
		case GEE_READ_ONLY_COLLECTION_READ_ONLY_VIEW_PROPERTY:
		g_value_take_object (value, gee_read_only_collection_get_read_only_view (self));
		break;
		case GEE_READ_ONLY_COLLECTION_G_TYPE:
		g_value_set_gtype (value, self->priv->g_type);
		break;
		case GEE_READ_ONLY_COLLECTION_G_DUP_FUNC:
		g_value_set_pointer (value, self->priv->g_dup_func);
		break;
		case GEE_READ_ONLY_COLLECTION_G_DESTROY_FUNC:
		g_value_set_pointer (value, self->priv->g_destroy_func);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gee_read_only_collection_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	GeeReadOnlyCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_READ_ONLY_COLLECTION, GeeReadOnlyCollection);
	switch (property_id) {
		case GEE_READ_ONLY_COLLECTION_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_READ_ONLY_COLLECTION_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_READ_ONLY_COLLECTION_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

