
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file EfigramDecoderAttributes.h
    \\brief Definition of EfigramDecoder Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "EfigramDecoderAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

EfigramDecoderAttributes::EfigramDecoderAttributes():
	database_(ParameterManager::getString("efi_root_database")),
	legend_database_(ParameterManager::getString("efi_legend_root_database")),
	clim_database_(ParameterManager::getString("efi_clim_root_database")),
	dates_(ParameterManager::getStringArray("efi_dates")),
	clim_param_(ParameterManager::getString("efi_clim_parameter")),
	clim_date_(ParameterManager::getString("efi_clim_date")),
	clim_step_(ParameterManager::getInt("efi_clim_step")),
	steps_(ParameterManager::getIntArray("efi_steps")),
	param_(ParameterManager::getString("efi_parameter")),
	long_title_(ParameterManager::getBool("efi_long_title")),
	title_(ParameterManager::getBool("efi_title")),
	latitude_(ParameterManager::getDouble("efi_latitude")),
	longitude_(ParameterManager::getDouble("efi_longitude")),
	legend_(ParameterManager::getBool("efi_legend")),
	legend_colours_(ParameterManager::getStringArray("efi_legend_colour_list")),
	legend_type_(ParameterManager::getString("efi_legend_box_type")),
	legend_normal_thickness_(ParameterManager::getInt("efi_legend_normal_thickness"))
	,
	legend_normal_colour_(MagTranslator<string, Colour>().magics("efi_legend_normal_colour"))
	 
{
} 


EfigramDecoderAttributes::~EfigramDecoderAttributes()
{
	
}

    
void EfigramDecoderAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "efi";
	
	setAttribute(prefix, "efi_root_database", database_, params);
	setAttribute(prefix, "efi_legend_root_database", legend_database_, params);
	setAttribute(prefix, "efi_clim_root_database", clim_database_, params);
	setAttribute(prefix, "efi_dates", dates_, params);
	setAttribute(prefix, "efi_clim_parameter", clim_param_, params);
	setAttribute(prefix, "efi_clim_date", clim_date_, params);
	setAttribute(prefix, "efi_clim_step", clim_step_, params);
	setAttribute(prefix, "efi_steps", steps_, params);
	setAttribute(prefix, "efi_parameter", param_, params);
	setAttribute(prefix, "efi_long_title", long_title_, params);
	setAttribute(prefix, "efi_title", title_, params);
	setAttribute(prefix, "efi_latitude", latitude_, params);
	setAttribute(prefix, "efi_longitude", longitude_, params);
	setAttribute(prefix, "efi_legend", legend_, params);
	setAttribute(prefix, "efi_legend_colour_list", legend_colours_, params);
	setAttribute(prefix, "efi_legend_box_type", legend_type_, params);
	setAttribute(prefix, "efi_legend_normal_thickness", legend_normal_thickness_, params);
	
	setMember(prefix, "efi_legend_normal_colour", legend_normal_colour_, params);
	
}

void EfigramDecoderAttributes::copy(const EfigramDecoderAttributes& other)
{
	database_ = other.database_;
	legend_database_ = other.legend_database_;
	clim_database_ = other.clim_database_;
	dates_ = other.dates_;
	clim_param_ = other.clim_param_;
	clim_date_ = other.clim_date_;
	clim_step_ = other.clim_step_;
	steps_ = other.steps_;
	param_ = other.param_;
	long_title_ = other.long_title_;
	title_ = other.title_;
	latitude_ = other.latitude_;
	longitude_ = other.longitude_;
	legend_ = other.legend_;
	legend_colours_ = other.legend_colours_;
	legend_type_ = other.legend_type_;
	legend_normal_thickness_ = other.legend_normal_thickness_;
	legend_normal_colour_ = unique_ptr<Colour>(other.legend_normal_colour_->clone());
	
} 


bool EfigramDecoderAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "efigram")  )
		return true;
	
	return false;
}

void EfigramDecoderAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "efigram")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void EfigramDecoderAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " database = " <<  database_;
	out << " legend_database = " <<  legend_database_;
	out << " clim_database = " <<  clim_database_;
	out << " dates = " <<  dates_;
	out << " clim_param = " <<  clim_param_;
	out << " clim_date = " <<  clim_date_;
	out << " clim_step = " <<  clim_step_;
	out << " steps = " <<  steps_;
	out << " param = " <<  param_;
	out << " long_title = " <<  long_title_;
	out << " title = " <<  title_;
	out << " latitude = " <<  latitude_;
	out << " longitude = " <<  longitude_;
	out << " legend = " <<  legend_;
	out << " legend_colours = " <<  legend_colours_;
	out << " legend_type = " <<  legend_type_;
	out << " legend_normal_thickness = " <<  legend_normal_thickness_;
	out << " legend_normal_colour = " <<  *legend_normal_colour_;
	
	out << "]" << "\n";
}

void EfigramDecoderAttributes::toxml(ostream& out)  const
{
	out <<  "\"efigram\""; 
	out << ", \"efi_root_database\":";
	niceprint(out,database_);
	out << ", \"efi_legend_root_database\":";
	niceprint(out,legend_database_);
	out << ", \"efi_clim_root_database\":";
	niceprint(out,clim_database_);
	out << ", \"efi_dates\":";
	niceprint(out,dates_);
	out << ", \"efi_clim_parameter\":";
	niceprint(out,clim_param_);
	out << ", \"efi_clim_date\":";
	niceprint(out,clim_date_);
	out << ", \"efi_clim_step\":";
	niceprint(out,clim_step_);
	out << ", \"efi_steps\":";
	niceprint(out,steps_);
	out << ", \"efi_parameter\":";
	niceprint(out,param_);
	out << ", \"efi_long_title\":";
	niceprint(out,long_title_);
	out << ", \"efi_title\":";
	niceprint(out,title_);
	out << ", \"efi_latitude\":";
	niceprint(out,latitude_);
	out << ", \"efi_longitude\":";
	niceprint(out,longitude_);
	out << ", \"efi_legend\":";
	niceprint(out,legend_);
	out << ", \"efi_legend_colour_list\":";
	niceprint(out,legend_colours_);
	out << ", \"efi_legend_box_type\":";
	niceprint(out,legend_type_);
	out << ", \"efi_legend_normal_thickness\":";
	niceprint(out,legend_normal_thickness_);
	out << ", \"efi_legend_normal_colour\":";
	niceprint(out, *legend_normal_colour_);
	
}

static MagicsParameter<string> efi_root_database("efi_root_database", "", "");
static MagicsParameter<string> efi_legend_root_database("efi_legend_root_database", "", "");
static MagicsParameter<string> efi_clim_root_database("efi_clim_root_database", "", "");
static MagicsParameter<stringarray> efi_dates("efi_dates", stringarray(), "");
static MagicsParameter<string> efi_clim_parameter("efi_clim_parameter", "", "");
static MagicsParameter<string> efi_clim_date("efi_clim_date", "", "");
static MagicsParameter<int> efi_clim_step("efi_clim_step", 36, "");
static MagicsParameter<intarray> efi_steps("efi_steps", intarray(), "");
static MagicsParameter<string> efi_parameter("efi_parameter", "", "");
static MagicsParameter<string> efi_long_title("efi_long_title", "off", "");
static MagicsParameter<string> efi_title("efi_title", "off", "");
static MagicsParameter<double> efi_latitude("efi_latitude", 0, "");
static MagicsParameter<double> efi_longitude("efi_longitude", 0, "");
static MagicsParameter<string> efi_legend("efi_legend", "on", "");
static MagicsParameter<stringarray> efi_legend_colour_list("efi_legend_colour_list", stringarray(), "");
static MagicsParameter<string> efi_legend_box_type("efi_legend_box_type", "both", "");
static MagicsParameter<int> efi_legend_normal_thickness("efi_legend_normal_thickness", 4, "");
static MagicsParameter<string> efi_legend_normal_colour("efi_legend_normal_colour", "black", ""); 
