// undefined expression class -*- c++ -*-

#ifdef __GNUC__
# pragma implementation
#endif // __GNUC__
#include "Undefined.h"
#include "Printer.h"

/** @file Undefined.C
 * Undefined literal
 */

/* Copyright  1998-2001 Marko Mkel (msmakela@tcs.hut.fi).

   This file is part of MARIA, a reachability analyzer and model checker
   for high-level Petri nets.

   MARIA is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   MARIA is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   The GNU General Public License is often shipped with GNU software, and
   is generally kept in a file called COPYING or LICENSE.  If you do not
   have a copy of the license, write to the Free Software Foundation,
   59 Temple Place, Suite 330, Boston, MA 02111 USA. */

Undefined::Undefined (enum Fatalness fatalness) :
  Expression (),
  myFatalness (fatalness)
{
}

Undefined::~Undefined ()
{
}

class Value*
Undefined::do_eval (const class Valuation& valuation) const
{
  switch (myFatalness) {
  case fError:
    valuation.flag (errUndef, *this);
    return 0;
  case fFatalError:
    valuation.flag (errFatal, *this);
    return 0;
  }
  assert (false);
  return 0;
}

bool
Undefined::depends (const class VariableSet&,
		    bool) const
{
  return false;
}

bool
Undefined::forExpressions (bool (*operation)
			   (const class Expression&,void*),
			   void* data) const
{
  return
    (*operation) (*this, data);
}

#ifdef EXPR_COMPILE
# include "CExpression.h"

void
Undefined::compile (class CExpression& cexpr,
		    unsigned indent,
		    const char*,
		    const class VariableSet*) const
{
  cexpr.compileError (indent, myFatalness == fError ? errUndef : errFatal);
}

#endif // EXPR_COMPILE

void
Undefined::display (const class Printer& printer) const
{
  printer.printRaw (myFatalness == fFatalError ? "fatal" : "undefined");
}
