/*******************************************************************************
*                                                                              *
*   (C) 1997-2021 by Ernst W. Mayer.                                           *
*                                                                              *
*  This program is free software; you can redistribute it and/or modify it     *
*  under the terms of the GNU General Public License as published by the       *
*  Free Software Foundation; either version 2 of the License, or (at your      *
*  option) any later version.                                                  *
*                                                                              *
*  This program is distributed in the hope that it will be useful, but WITHOUT *
*  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or       *
*  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for   *
*  more details.                                                               *
*                                                                              *
*  You should have received a copy of the GNU General Public License along     *
*  with this program; see the file GPL.txt.  If not, you may view one at       *
*  http://www.fsf.org/licenses/licenses.html, or obtain one by writing to the  *
*  Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA     *
*  02111-1307, USA.                                                            *
*                                                                              *
*******************************************************************************/

/****************************************************************************
 * We now include this header file if it was not included before.
 ****************************************************************************/
#ifndef radix1008_avx_negadwt_consts_included
#define radix1008_avx_negadwt_consts_included

	#include "types.h"

	const uint64 radix1008_avx_negadwt_consts[1008] = {	// 8 entries per line ==> RADIX/8 lines:
		0x3FF0000000000000ull,0x3FEFFFFD74223EFDull,0x3FEFFFF5D08963B1ull,0x3FEFFFE91536A557ull,0x3FEFFFD7422C0AA5ull,0x3FEFFFC0576C69CDull,0x3FEFFFA454FB687Bull,0x3FEFFF833ADD7BD8ull,
		0x3FEFFF5D0917E885ull,0x3FEFFF31BFB0C29Bull,0x3FEFFF015EAEEDAEull,0x3FEFFECBE61A1CC7ull,0x3FEFFE9155FAD266ull,0x3FEFFE51AE5A607Eull,0x3FEFFE0CEF42E875ull,0x3FEFFDC318BF5B23ull,
		0x3FEFFD742ADB78D0ull,0x3FEFFD2025A3D131ull,0x3FEFFCC70925C367ull,0x3FEFFC68D56F7DFCull,0x3FEFFC058A8FFEE1ull,0x3FEFFB9D2897136Eull,0x3FEFFB2FAF95585Aull,0x3FEFFABD1F9C39C0ull,
		0x3FEFFA4578BDF313ull,0x3FEFF9C8BB0D8F26ull,0x3FEFF946E69EE81Dull,0x3FEFF8BFFB86A774ull,0x3FEFF833F9DA45F7ull,0x3FEFF7A2E1B00BBDull,0x3FEFF70CB31F1029ull,0x3FEFF6716E3F39E3ull,
		0x3FEFF5D113293ED5ull,0x3FEFF52BA1F6A428ull,0x3FEFF4811AC1BE3Full,0x3FEFF3D17DA5B0B2ull,0x3FEFF31CCABE6E4Cull,0x3FEFF2630228B903ull,0x3FEFF1A4240221F9ull,0x3FEFF0E030690971ull,
		0x3FEFF017277C9ECFull,0x3FEFEF49095CE090ull,0x3FEFEE75D62A9C46ull,0x3FEFED9D8E076E94ull,0x3FEFECC03115C326ull,0x3FEFEBDDBF78D4AEull,0x3FEFEAF63954ACDCull,0x3FEFEA099ECE245Dull,
		0x3FEFE917F00AE2CDull,0x3FEFE8212D315EBAull,0x3FEFE7255668DD97ull,0x3FEFE6246BD973BAull,0x3FEFE51E6DAC0454ull,0x3FEFE4135C0A4168ull,0x3FEFE303371EABCBull,0x3FEFE1EDFF149315ull,
		0x3FEFE0D3B41815A2ull,0x3FEFDFB456562084ull,0x3FEFDE8FE5FC6F82ull,0x3FEFDD6663398D0Cull,0x3FEFDC37CE3CD235ull,0x3FEFDB04273666ADull,0x3FEFD9CB6E5740B8ull,0x3FEFD88DA3D12526ull,
		0x3FEFD74AC7D6A74Bull,0x3FEFD602DA9B28F9ull,0x3FEFD4B5DC52DA75ull,0x3FEFD363CD32BA71ull,0x3FEFD20CAD709600ull,0x3FEFD0B07D430893ull,0x3FEFCF4F3CE17BEDull,0x3FEFCDE8EC842817ull,
		0x3FEFCC7D8C64135Full,0x3FEFCB0D1CBB1247ull,0x3FEFC9979DC3C781ull,0x3FEFC81D0FB9A3E4ull,0x3FEFC69D72D8E661ull,0x3FEFC518C75E9BFDull,0x3FEFC38F0D889FC2ull,0x3FEFC20045959ABBull,
		0x3FEFC06C6FC503E7ull,0x3FEFBED38C57202Eull,0x3FEFBD359B8D0258ull,0x3FEFBB929DA88B04ull,0x3FEFB9EA92EC689Bull,0x3FEFB83D7B9C1747ull,0x3FEFB68B57FBE0E8ull,0x3FEFB4D42850DD07ull,
		0x3FEFB317ECE0F0D0ull,0x3FEFB156A5F2CF02ull,0x3FEFAF9053CDF7E6ull,0x3FEFADC4F6BAB941ull,0x3FEFABF48F022E4Full,0x3FEFAA1F1CEE3FB0ull,0x3FEFA844A0C9A35Full,0x3FEFA6651ADFDCA8ull,
		0x3FEFA4808B7D3C19ull,0x3FEFA296F2EEDF79ull,0x3FEFA0A85182B1B7ull,0x3FEF9EB4A7876AE4ull,0x3FEF9CBBF54C9021ull,0x3FEF9ABE3B227393ull,0x3FEF98BB795A345Bull,0x3FEF96B3B045BE83ull,
		0x3FEF94A6E037CAF5ull,0x3FEF92950983DF6Bull,0x3FEF907E2C7E4E65ull,0x3FEF8E62497C3719ull,0x3FEF8C4160D38565ull,0x3FEF8A1B72DAF1C4ull,0x3FEF87F07FEA013Eull,0x3FEF85C08859055Cull,
		0x3FEF838B8C811C17ull,0x3FEF81518CBC2FCDull,0x3FEF7F128964F730ull,0x3FEF7CCE82D6F539ull,0x3FEF7A85796E791Aull,0x3FEF78376D889E2Eull,0x3FEF75E45F834BECull,0x3FEF738C4FBD35D5ull,
		0x3FEF712F3E95DB67ull,0x3FEF6ECD2C6D880Eull,0x3FEF6C6619A55315ull,0x3FEF69FA069F1F94ull,0x3FEF6788F3BD9C63ull,0x3FEF6512E164440Aull,0x3FEF6297CFF75CB0ull,0x3FEF6017BFDBF80Cull,
		0x3FEF5D92B177F354ull,0x3FEF5B08A531F72Eull,0x3FEF58799B71779Full,0x3FEF55E5949EB3FAull,0x3FEF534C9122B6D0ull,0x3FEF50AE916755E0ull,0x3FEF4E0B95D73205ull,0x3FEF4B639EDDB726ull,
		0x3FEF48B6ACE71C23ull,0x3FEF4604C06062C6ull,0x3FEF434DD9B757B2ull,0x3FEF4091F95A924Eull,0x3FEF3DD11FB974B6ull,0x3FEF3B0B4D442BABull,0x3FEF3840826BAE7Eull,0x3FEF3570BFA1BEFEull,
		0x3FEF329C0558E969ull,0x3FEF2FC254048456ull,0x3FEF2CE3AC18B0A7ull,0x3FEF2A000E0A5970ull,0x3FEF27177A4F33EDull,0x3FEF2429F15DBF67ull,0x3FEF213773AD4526ull,0x3FEF1E4001B5D85Eull,
		0x3FEF1B439BF05619ull,0x3FEF184242D66526ull,0x3FEF153BF6E27605ull,0x3FEF1230B88FC2D5ull,0x3FEF0F20885A4F3Cull,0x3FEF0C0B66BEE859ull,0x3FEF08F1543B24ADull,0x3FEF05D2514D6406ull,
		0x3FEF02AE5E74CF6Eull,0x3FEEFF857C315913ull,0x3FEEFC57AB03BC37ull,0x3FEEF924EB6D7D17ull,0x3FEEF5ED3DF0E8DBull,0x3FEEF2B0A311157Dull,0x3FEEEF6F1B51E1B7ull,0x3FEEEC28A737F4ECull,
		0x3FEEE8DD4748BF15ull,0x3FEEE58CFC0A78A9ull,0x3FEEE237C604228Dull,0x3FEEDEDDA5BD85F6ull,0x3FEEDB7E9BBF345Bull,0x3FEED81AA892875Cull,0x3FEED4B1CCC1A0AEull,0x3FEED14408D76A01ull,
		0x3FEECDD15D5F94EDull,0x3FEECA59CAE69ADEull,0x3FEEC6DD51F9BCF8ull,0x3FEEC35BF3270404ull,0x3FEEBFD5AEFD405Aull,0x3FEEBC4A860C09C9ull,0x3FEEB8BA78E3BF7Full,0x3FEEB525881587F3ull,
		0x3FEEB18BB43350D1ull,0x3FEEADECFDCFCEDEull,0x3FEEAA49657E7DE2ull,0x3FEEA6A0EBD3A092ull,0x3FEEA2F391644078ull,0x3FEE9F4156C62DDAull,0x3FEE9B8A3C8FFFA4ull,0x3FEE97CE4359134Eull,
		0x3FEE940D6BB98CC5ull,0x3FEE9047B64A5654ull,0x3FEE8C7D23A52089ull,0x3FEE88ADB464621Eull,0x3FEE84D9692357E1ull,0x3FEE8100427E049Aull,0x3FEE7D22411130F5ull,0x3FEE793F657A6B63ull,
		0x3FEE7557B0580807ull,0x3FEE716B2249209Cull,0x3FEE6D79BBED9458ull,0x3FEE69837DE607D5ull,0x3FEE658868D3E4F9ull,0x3FEE61887D595AD8ull,0x3FEE5D83BC195D9Full,0x3FEE597A25B7A677ull,
		0x3FEE556BBAD8B36Bull,0x3FEE51587C21C751ull,0x3FEE4D406A38E9ABull,0x3FEE492385C4E68Full,0x3FEE4501CF6D4E8Dull,0x3FEE40DB47DA7693ull,0x3FEE3CAFEFB577D5ull,0x3FEE387FC7A82FAEull,
		0x3FEE344AD05D3F86ull,0x3FEE30110A800CBAull,0x3FEE2BD276BCC07Dull,0x3FEE278F15C047C0ull,0x3FEE2346E8385312ull,0x3FEE1EF9EED35688ull,0x3FEE1AA82A4089A1ull,0x3FEE16519B2FE729ull,
		0x3FEE11F642522D1Cull,0x3FEE0D962058DC8Cull,0x3FEE093135F63984ull,0x3FEE04C783DD4AECull,0x3FEE00590AC1DA6Bull,0x3FEDFBE5CB58744Cull,0x3FEDF76DC6566761ull,0x3FEDF2F0FC71C4E5ull,
		0x3FEDEE6F6E616061ull,0x3FEDE9E91CDCCF8Cull,0x3FEDE55E089C6A31ull,0x3FEDE0CE32594A11ull,0x3FEDDC399ACD4AC1ull,0x3FEDD7A042B30995ull,0x3FEDD3022AC5E57Bull,0x3FEDCE5F53C1FEDEull,
		0x3FEDC9B7BE64378Eull,0x3FEDC50B6B6A329Aull,0x3FEDC05A5B925437ull,0x3FEDBBA48F9BC19Full,0x3FEDB6EA084660F6ull,0x3FEDB22AC652D928ull,0x3FEDAD66CA8291CAull,0x3FEDA89E1597B2FEull,
		0x3FEDA3D0A8552555ull,0x3FED9EFE837E91ABull,0x3FED9A27A7D8610Bull,0x3FED954C1627BC90ull,0x3FED906BCF328D46ull,0x3FED8B86D3BF7C09ull,0x3FED869D2495F164ull,0x3FED81AEC27E1577ull,
		0x3FED7CBBAE40CFD0ull,0x3FED77C3E8A7C751ull,0x3FED72C7727D620Aull,0x3FED6DC64C8CC520ull,0x3FED68C077A1D4A6ull,0x3FED63B5F4893380ull,0x3FED5EA6C4104343ull,0x3FED5992E7052411ull,
		0x3FED547A5E36B47Cull,0x3FED4F5D2A749162ull,0x3FED4A3B4C8F15CFull,0x3FED4514C5575AD9ull,0x3FED3FE9959F377Full,0x3FED3AB9BE39408Aull,0x3FED35853FF8C869ull,0x3FED304C1BB1DF11ull,
		0x3FED2B0E523951DBull,0x3FED25CBE464AB60ull,0x3FED2084D30A335Aull,0x3FED1B391F00EE81ull,0x3FED15E8C9209E67ull,0x3FED1093D241C158ull,0x3FED0B3A3B3D9237ull,0x3FED05DC04EE0859ull,
		0x3FED0079302DD767ull,0x3FECFB11BDD86F38ull,0x3FECF5A5AEC9FBACull,0x3FECF03503DF6490ull,0x3FECEABFBDF64D72ull,0x3FECE545DDED1585ull,0x3FECDFC764A2D779ull,0x3FECDA4452F7695Cull,
		0x3FECD4BCA9CB5C71ull,0x3FECCF3069FFFD0Full,0x3FECC99F9477527Full,0x3FECC40A2A141ED3ull,0x3FECBE702BB9DEC9ull,0x3FECB8D19A4CC99Full,0x3FECB32E76B1D0F4ull,0x3FECAD86C1CEA0A4ull,
		0x3FECA7DA7C899E9Dull,0x3FECA229A7C9EAC3ull,0x3FEC9C7444775EC4ull,0x3FEC96BA537A8DF9ull,0x3FEC90FBD5BCC53Cull,0x3FEC8B38CC280AC5ull,0x3FEC857137A71E06ull,0x3FEC7FA519257783ull,
		0x3FEC79D4718F48AFull,0x3FEC73FF41D17BC4ull,0x3FEC6E258AD9B3A1ull,0x3FEC68474D964BA0ull,0x3FEC62648AF65771ull,0x3FEC5C7D43E9A2F7ull,0x3FEC56917960B21Dull,0x3FEC50A12C4CC0B6ull,
		0x3FEC4AAC5D9FC250ull,0x3FEC44B30E4C6211ull,0x3FEC3EB53F460291ull,0x3FEC38B2F180BDB1ull,0x3FEC32AC25F16475ull,0x3FEC2CA0DD8D7EDFull,0x3FEC2691194B4BC4ull,0x3FEC207CDA21C0A8ull,
		0x3FEC1A6421088998ull,0x3FEC1446EEF808FCull,0x3FEC0E2544E95777ull,0x3FEC07FF23D643BBull,0x3FEC01D48CB95263ull,0x3FEBFBA5808DBDC9ull,0x3FEBF572004F75E2ull,0x3FEBEF3A0CFB2011ull,
		0x3FEBE8FDA78E1703ull,0x3FEBE2BCD1066A83ull,0x3FEBDC778A62DF56ull,0x3FEBD62DD4A2EF0Eull,0x3FEBCFDFB0C6C7E5ull,0x3FEBC98D1FCF4C8Full,0x3FEBC33622BE141Aull,0x3FEBBCDABA9569BAull,
		0x3FEBB67AE8584CAAull,0x3FEBB016AD0A6FFDull,0x3FEBA9AE09B03A73ull,0x3FEBA340FF4EC657ull,0x3FEB9CCF8EEBE14Full,0x3FEB9659B98E0C33ull,0x3FEB8FDF803C7AE7ull,0x3FEB8960E3FF142Dull,
		0x3FEB82DDE5DE717Eull,0x3FEB7C5686E3DEDCull,0x3FEB75CAC8195AAEull,0x3FEB6F3AAA89958Full,0x3FEB68A62F3FF227ull,0x3FEB620D57488501ull,0x3FEB5B7023B01460ull,0x3FEB54CE95841811ull,
		0x3FEB4E28ADD2B944ull,0x3FEB477E6DAAD261ull,0x3FEB40CFD61BEEDAull,0x3FEB3A1CE8364B01ull,0x3FEB3365A50AD3DEull,0x3FEB2CAA0DAB2702ull,0x3FEB25EA2329925Dull,0x3FEB1F25E6991410ull,
		0x3FEB185D590D5A44ull,0x3FEB11907B9AC2FCull,0x3FEB0ABF4F565BEAull,0x3FEB03E9D555E242ull,0x3FEAFD100EAFC290ull,0x3FEAF631FC7B1888ull,0x3FEAEF4F9FCFAEDDull,0x3FEAE868F9C5FF15ull,
		0x3FEAE17E0B773156ull,0x3FEADA8ED5FD1C43ull,0x3FEAD39B5A7244C6ull,0x3FEACCA399F1DDEAull,0x3FEAC5A79597C8A8ull,0x3FEABEA74E8093BFull,0x3FEAB7A2C5C97B84ull,0x3FEAB099FC9069B4ull,
		0x3FEAA98CF3F3F54Aull,0x3FEAA27BAD13624Cull,0x3FEA9B66290EA1A3ull,0x3FEA944C690650E8ull,0x3FEA8D2E6E1BBA3Aull,0x3FEA860C3970D40Full,0x3FEA7EE5CC284103ull,0x3FEA77BB27654FAEull,
		0x3FEA708C4C4BFA74ull,0x3FEA69593C00E754ull,0x3FEA6221F7A967BEull,0x3FEA5AE6806B7862ull,0x3FEA53A6D76DC0FEull,0x3FEA4C62FDD79437ull,0x3FEA451AF4D0EF61ull,0x3FEA3DCEBD827A56ull,
		0x3FEA367E59158747ull,0x3FEA2F29C8B41287ull,0x3FEA27D10D88C262ull,0x3FEA207428BEE6E8ull,0x3FEA19131B8279C4ull,0x3FEA11ADE7001E05ull,0x3FEA0A448C651FF2ull,0x3FEA02D70CDF74DBull,
		0x3FE9FB65699DBAE6ull,0x3FE9F3EFA3CF38E1ull,0x3FE9EC75BCA3DE12ull,0x3FE9E4F7B54C4203ull,0x3FE9DD758EF9A457ull,0x3FE9D5EF4ADDEC96ull,0x3FE9CE64EA2BA9FBull,0x3FE9C6D66E161348ull,
		0x3FE9BF43D7D10690ull,0x3FE9B7AD28910909ull,0x3FE9B012618B46DBull,0x3FE9A87383F592EEull,0x3FE9A0D0910666B7ull,0x3FE9992989F4E209ull,0x3FE9917E6FF8CAE3ull,0x3FE989CF444A8D3Full,
		0x3FE9821C08233ADEull,0x3FE97A64BCBC8B18ull,0x3FE972A96350DAA9ull,0x3FE96AE9FD1B2B82ull,0x3FE963268B572492ull,0x3FE95B5F0F411197ull,0x3FE953938A15E2EAull,0x3FE94BC3FD132D51ull,
		0x3FE943F0697729C4ull,0x3FE93C18D080B542ull,0x3FE9343D336F509Cull,0x3FE92C5D93832041ull,0x3FE92479F1FCEC0Bull,0x3FE91C92501E1F0Eull,0x3FE914A6AF28C763ull,0x3FE90CB7105F95F3ull,
		0x3FE904C37505DE4Bull,0x3FE8FCCBDE5F965Full,0x3FE8F4D04DB1565Dull,0x3FE8ECD0C4405876ull,0x3FE8E4CD435278ADull,0x3FE8DCC5CC2E34A1ull,0x3FE8D4BA601AAB58ull,0x3FE8CCAB005F9D11ull,
		0x3FE8C497AE456B06ull,0x3FE8BC806B151741ull,0x3FE8B46538184462ull,0x3FE8AC461699356Eull,0x3FE8A42307E2CD97ull,0x3FE89BFC0D40900Bull,0x3FE893D127FE9FBBull,0x3FE88BA25969BF2Bull,
		0x3FE8836FA2CF5039ull,0x3FE87B39057D53EBull,0x3FE872FE82C26A36ull,0x3FE86AC01BEDD1CDull,0x3FE8627DD24F67EAull,0x3FE85A37A737A817ull,0x3FE851ED9BF7ABFAull,0x3FE8499FB1E12B20ull,
		0x3FE8414DEA467AC6ull,0x3FE838F8467A8DA2ull,0x3FE8309EC7D0F3B2ull,0x3FE828416F9DD9FFull,0x3FE81FE03F360A6Dull,0x3FE8177B37EEEB7Full,0x3FE80F125B1E8028ull,0x3FE806A5AA1B678Dull,
		0x3FE7FE35263CDCD4ull,0x3FE7F5C0D0DAB6E9ull,0x3FE7ED48AB4D684Cull,0x3FE7E4CCB6EDFED6ull,0x3FE7DC4CF5162385ull,0x3FE7D3C967201A43ull,0x3FE7CB420E66C1AFull,0x3FE7C2B6EC4592E9ull,
		0x3FE7BA280218A154ull,0x3FE7B195513C9A68ull,0x3FE7A8FEDB0EC571ull,0x3FE7A064A0ED035Dull,0x3FE797C6A435CE85ull,0x3FE78F24E6483A6Full,0x3FE7867F6883F39Full,0x3FE77DD62C493F57ull,
		0x3FE7752932F8FB65ull,0x3FE76C787DF49DE5ull,0x3FE763C40E9E350Full,0x3FE75B0BE65866FBull,0x3FE7525006867166ull,0x3FE74990708C2981ull,0x3FE740CD25CDFBB2ull,0x3FE7380627B0EB5Cull,
		0x3FE72F3B779A92AAull,0x3FE7266D16F12252ull,0x3FE71D9B071B615Dull,0x3FE714C54980ACF0ull,0x3FE70BEBDF88F80Full,0x3FE7030ECA9CCB6Aull,0x3FE6FA2E0C25451Aull,0x3FE6F149A58C1872ull,
		0x3FE6E861983B8DBEull,0x3FE6DF75E59E820Cull,0x3FE6D6868F2066F3ull,0x3FE6CD93962D4257ull,0x3FE6C49CFC31AE32ull,0x3FE6BBA2C29AD857ull,0x3FE6B2A4EAD6823Aull,0x3FE6A9A3765300B5ull,
		0x3FE6A09E667F3BCDull,0x3FE69795BCCAAE78ull,0x3FE68E897AA56664ull,0x3FE68579A18003BCull,0x3FE67C6632CBB8E9ull,0x3FE6734F2FFA4A60ull,0x3FE66A349A7E0E5Cull,0x3FE6611673C9ECAFull,
		0x3FE657F4BD515E7Dull,0x3FE64ECF78886E06ull,0x3FE645A6A6E3B669ull,0x3FE63C7A49D8636Cull,0x3FE6334A62DC313Bull,0x3FE62A16F3656C31ull,0x3FE620DFFCEAF09Bull,0x3FE617A580E42A7Bull,
		0x3FE60E6780C9154Full,0x3FE60525FE123BD3ull,0x3FE5FBE0FA38B7C6ull,0x3FE5F29876B631AFull,0x3FE5E94C7504E09Cull,0x3FE5DFFCF69F89EDull,0x3FE5D6A9FD018114ull,0x3FE5CD5389A6A756ull,
		0x3FE5C3F99E0B6B95ull,0x3FE5BA9C3BACCA0Dull,0x3FE5B13B64084C1Cull,0x3FE5A7D7189C0802ull,0x3FE59E6F5AE6A0A7ull,0x3FE595042C67455Cull,0x3FE58B958E9DB19Eull,0x3FE58223830A2CDCull,
		0x3FE578AE0B2D8A35ull,0x3FE56F3528892840ull,0x3FE565B8DC9EF0C9ull,0x3FE55C3928F15899ull,0x3FE552B60F035F34ull,0x3FE5492F90588EA0ull,0x3FE53FA5AE74FB23ull,0x3FE536186ADD4307ull,
		0x3FE52C87C7168E5Dull,0x3FE522F3C4A68EBEull,0x3FE5195C65137F0Cull,0x3FE50FC1A9E42338ull,0x3FE50623949FC7FDull,0x3FE4FC8226CE42AAull,0x3FE4F2DD61F7F0DCull,0x3FE4E93547A5B844ull,
		0x3FE4DF89D9610668ull,0x3FE4D5DB18B3D062ull,0x3FE4CC29072892A5ull,0x3FE4C273A64A50BCull,0x3FE4B8BAF7A49509ull,0x3FE4AEFEFCC3708Bull,0x3FE4A53FB7337A9Bull,0x3FE49B7D2881D0B0ull,
		0x3FE491B7523C161Dull,0x3FE487EE35F073D1ull,0x3FE47E21D52D981Dull,0x3FE474523182B66Eull,0x3FE46A7F4C7F8712ull,0x3FE460A927B446F6ull,0x3FE456CFC4B1B768ull,0x3FE44CF325091DD6ull,
		0x3FE443134A4C438Full,0x3FE43930360D7580ull,0x3FE42F49E9DF83FBull,0x3FE425606755C26Eull,0x3FE41B73B004072Bull,0x3FE41183C57EAB20ull,0x3FE40790A95A899Full,0x3FE3FD9A5D2D0015ull,
		0x3FE3F3A0E28BEDD1ull,0x3FE3E9A43B0DB3BFull,0x3FE3DFA468493427ull,0x3FE3D5A16BD5D26Full,0x3FE3CB9B474B72D9ull,0x3FE3C191FC427A41ull,0x3FE3B7858C53CDDEull,0x3FE3AD75F918D2FFull,
		0x3FE3A363442B6ECBull,0x3FE3994D6F260600ull,0x3FE38F347BA37CAFull,0x3FE385186B3F3600ull,0x3FE37AF93F9513EAull,0x3FE370D6FA4176F7ull,0x3FE366B19CE13DFFull,0x3FE35C892911C5E8ull,
		0x3FE3525DA070E964ull,0x3FE3482F049D00ADull,0x3FE33DFD5734E146ull,0x3FE333C899D7DDB8ull,0x3FE32990CE25C54Full,0x3FE31F55F5BEE3D9ull,0x3FE3151812440163ull,0x3FE30AD7255661F7ull,
		0x3FE300933097C559ull,0x3FE2F64C35AA66C7ull,0x3FE2EC023630FCB1ull,0x3FE2E1B533CEB87Eull,0x3FE2D76530274641ull,0x3FE2CD122CDECC7Dull,0x3FE2C2BC2B99EBDFull,0x3FE2B8632DFDBEFAull,
		0x3FE2AE0735AFDA09ull,0x3FE2A3A844564AA5ull,0x3FE299465B979786ull,0x3FE28EE17D1AC040ull,0x3FE28479AA873CFEull,0x3FE27A0EE584FE3Full,0x3FE26FA12FBC6C94ull,0x3FE265308AD6685Aull,
		0x3FE25ABCF87C4978ull,0x3FE250467A57DF1Cull,0x3FE245CD12136F74ull,0x3FE23B50C159B76Eull,0x3FE230D189D5EA73ull,0x3FE2264F6D33B221ull,0x3FE21BCA6D1F2E09ull,0x3FE211428B44F369ull,
		0x3FE206B7C9520CEDull,0x3FE1FC2A28F3FA61ull,0x3FE1F199ABD8B078ull,0x3FE1E70653AE987Eull,0x3FE1DC702224901Aull,0x3FE1D1D718E9E905ull,0x3FE1C73B39AE68C8ull,0x3FE1BC9C86224878ull,
		0x3FE1B1FAFFF6346Dull,0x3FE1A756A8DB4C03ull,0x3FE19CAF8283214Eull,0x3FE192058E9FB8DEull,0x3FE18758CEE38971ull,0x3FE17CA945017BB4ull,0x3FE171F6F2ACE9F9ull,0x3FE16741D9999FF8ull,
		0x3FE15C89FB7BDA82ull,0x3FE151CF5A084742ull,0x3FE14711F6F40474ull,0x3FE13C51D3F4A0A2ull,0x3FE1318EF2C01A5Bull,0x3FE126C9550CDFEEull,0x3FE11C00FC91CF29ull,0x3FE11135EB06350Dull,
		0x3FE106682221CD8Aull,0x3FE0FB97A39CC33Bull,0x3FE0F0C4712FAF1Full,0x3FE0E5EE8C939850ull,0x3FE0DB15F781F3C2ull,0x3FE0D03AB3B4A3F7ull,0x3FE0C55CC2E5F8BFull,0x3FE0BA7C26D0AEEBull,
		0x3FE0AF98E12FF00Dull,0x3FE0A4B2F3BF522Bull,0x3FE099CA603AD77Dull,0x3FE08EDF285EEE26ull,0x3FE083F14DE86FECull,0x3FE07900D294A1F0ull,0x3FE06E0DB8213469ull,0x3FE06318004C425Full,
		0x3FE0581FACD4515Eull,0x3FE04D24BF785135ull,0x3FE0422739F79BACull,0x3FE037271E11F43Eull,0x3FE02C246D8787CFull,0x3FE0211F2A18EC69ull,0x3FE01617558720F1ull,0x3FE00B0CF1938CE1ull,
		0x3FE0000000000000ull,0x3FDFE9E1051D6438ull,0x3FDFD3BCF6048580ull,0x3FDFBD93D63B71DCull,0x3FDFA765A94905ACull,0x3FDF913272B4EB1Eull,0x3FDF7AFA3607999Eull,0x3FDF64BCF6CA5546ull,
		0x3FDF4E7AB8872E4Eull,0x3FDF38337EC90079ull,0x3FDF21E74D1B728Aull,0x3FDF0B96270AF5AFull,0x3FDEF5401024C4F4ull,0x3FDEDEE50BF6E4AEull,0x3FDEC8851E1021EFull,0x3FDEB2204A0011F1ull,
		0x3FDE9BB693571187ull,0x3FDE8547FDA6448Cull,0x3FDE6ED48C7F9551ull,0x3FDE585C4375B409ull,0x3FDE41DF261C163Full,0x3FDE2B5D3806F63Bull,0x3FDE14D67CCB5277ull,0x3FDDFE4AF7FEED09ull,
		0x3FDDE7BAAD384B13ull,0x3FDDD125A00EB432ull,0x3FDDBA8BD41A31E8ull,0x3FDDA3ED4CF38F0Cull,0x3FDD8D4A0E345738ull,0x3FDD76A21B76D635ull,0x3FDD5FF578561769ull,0x3FDD4944286DE542ull,
		0x3FDD328E2F5AC8A7ull,0x3FDD1BD390BA0862ull,0x3FDD05145029A88Cull,0x3FDCEE50714869FDull,0x3FDCD787F7B5C9B4ull,0x3FDCC0BAE712004Aull,0x3FDCA9E942FE0155ull,0x3FDC93130F1B7ADEull,
		0x3FDC7C384F0CD4C4ull,0x3FDC655906753030ull,0x3FDC4E7538F866FCull,0x3FDC378CEA3B0B1Eull,0x3FDC20A01DE26617ull,0x3FDC09AED794785Eull,0x3FDBF2B91AF7F8C8ull,0x3FDBDBBEEBB453F6ull,
		0x3FDBC4C04D71ABC1ull,0x3FDBADBD43D8D6A1ull,0x3FDB96B5D2935F1Eull,0x3FDB7FA9FD4B8333ull,0x3FDB6899C7AC33C1ull,0x3FDB5185356113F4ull,0x3FDB3A6C4A1678ADull,0x3FDB234F097967F2ull,
		0x3FDB0C2D77379853ull,0x3FDAF50796FF7054ull,0x3FDADDDD6C8005DCull,0x3FDAC6AEFB691D99ull,0x3FDAAF7C476B2A6Eull,0x3FDA984554374CDAull,0x3FDA810A257F5263ull,0x3FDA69CABEF5B501ull,
		0x3FDA5287244D9A84ull,0x3FDA3B3F593AD3FDull,0x3FDA23F36171DD2Dull,0x3FDA0CA340A7DBE8ull,0x3FD9F54EFA929F7Full,0x3FD9DDF692E8A02Cull,0x3FD9C69A0D60FE77ull,0x3FD9AF396DB382A1ull,
		0x3FD997D4B7989C0Bull,0x3FD9806BEEC960A0ull,0x3FD968FF16FF8C3Dull,0x3FD9518E33F58017ull,0x3FD93A1949664225ull,0x3FD922A05B0D7C8Aull,0x3FD90B236CA77CF9ull,0x3FD8F3A281F1341Dull,
		0x3FD8DC1D9EA83507ull,0x3FD8C494C68AB48Bull,0x3FD8AD07FD5788B2ull,0x3FD8957746CE281Bull,0x3FD87DE2A6AEA963ull,0x3FD8664A20B9C28Full,0x3FD84EADB8B0C871ull,0x3FD8370D7255AE0Full,
		0x3FD81F69516B040Aull,0x3FD807C159B3F806ull,0x3FD7F0158EF4540Full,0x3FD7D865F4F07E00ull,0x3FD7C0B28F6D76EDull,0x3FD7A8FB6230DA82ull,0x3FD791407100DE70ull,0x3FD77981BFA451D2ull,
		0x3FD761BF51E29C90ull,0x3FD749F92B83BEC7ull,0x3FD7322F50505031ull,0x3FD71A61C4117F88ull,0x3FD702908A9111ECull,0x3FD6EABBA799624Aull,0x3FD6D2E31EF560C0ull,0x3FD6BB06F4709206ull,
		0x3FD6A3272BD70ECDull,0x3FD68B43C8F5832Aull,0x3FD6735CCF992DFBull,0x3FD65B72438FE046ull,0x3FD6438428A7FCA7ull,0x3FD62B9282B076ADull,0x3FD6139D5578D244ull,0x3FD5FBA4A4D12317ull,
		0x3FD5E3A8748A0BF5ull,0x3FD5CBA8C874BE39ull,0x3FD5B3A5A462F928ull,0x3FD59B9F0C27095Cull,0x3FD583950393C822ull,0x3FD56B878E7C9AE6ull,0x3FD55376B0B5728Eull,0x3FD53B626E12CAE5ull,
		0x3FD5234ACA69A9FEull,0x3FD50B2FC98F9F94ull,0x3FD4F3116F5AC471ull,0x3FD4DAEFBFA1B9D3ull,0x3FD4C2CABE3BA8CBull,0x3FD4AAA26F0041A5ull,0x3FD49276D5C7BB48ull,0x3FD47A47F66AD29Dull,
		0x3FD46215D4C2C9EEull,0x3FD449E074A9684Eull,0x3FD431A7D9F8F8F7ull,0x3FD4196C088C4AB2ull,0x3FD4012D043EAF37ull,0x3FD3E8EAD0EBFA8Full,0x3FD3D0A572708279ull,0x3FD3B85CECA91DCDull,
		0x3FD3A011437323DCull,0x3FD387C27AAC6BD5ull,0x3FD36F7096334C28ull,0x3FD3571B99E699E4ull,0x3FD33EC389A5A81Eull,0x3FD3266869504752ull,0x3FD30E0A3CC6C4C3ull,0x3FD2F5A907E9E9E1ull,
		0x3FD2DD44CE9AFBA7ull,0x3FD2C4DD94BBBA00ull,0x3FD2AC735E2E5F25ull,0x3FD294062ED59F06ull,0x3FD27B960A94A6A2ull,0x3FD26322F54F1B70ull,0x3FD24AACF2E91ABFull,0x3FD2323407473915ull,
		0x3FD219B8364E8193ull,0x3FD2013983E47556ull,0x3FD1E8B7F3EF0AD4ull,0x3FD1D0338A54AD47ull,0x3FD1B7AC4AFC3C02ull,0x3FD19F2239CD09DBull,0x3FD186955AAEDC88ull,0x3FD16E05B189EC01ull,
		0x3FD155734246E1E2ull,0x3FD13CDE10CED8C8ull,0x3FD12446210B5BB5ull,0x3FD10BAB76E6656Full,0x3FD0F30E164A5FE4ull,0x3FD0DA6E03222383ull,0x3FD0C1CB4158F6A5ull,0x3FD0A925D4DA8CE8ull,
		0x3FD0907DC1930690ull,0x3FD077D30B6EEFE9ull,0x3FD05F25B65B40A5ull,0x3FD04675C6455B3Dull,0x3FD02DC33F1B0C52ull,0x3FD0150E24CA8A0Bull,0x3FCFF8ACF684E6EDull,0x3FCFC7388CE39FD3ull,
		0x3FCF95BF14901CBEull,0x3FCF6440956A09B0ull,0x3FCF32BD1751DF77ull,0x3FCF0134A228E26Aull,0x3FCECFA73DD1212Cull,0x3FCE9E14F22D7366ull,0x3FCE6C7DC7217888ull,0x3FCE3AE1C4919687ull,
		0x3FCE0940F262F89Eull,0x3FCDD79B587B8E08ull,0x3FCDA5F0FEC208C1ull,0x3FCD7441ED1DDC44ull,0x3FCD428E2B773C48ull,0x3FCD10D5C1B71B7Full,0x3FCCDF18B7C72A53ull,0x3FCCAD571591D5A3ull,
		0x3FCC7B90E3024582ull,0x3FCC49C628045BF3ull,0x3FCC17F6EC84B3A7ull,0x3FCBE62338709EBBull,0x3FCBB44B13B62571ull,0x3FCB826E864404F4ull,0x3FCB508D9809AE0Full,0x3FCB1EA850F743EAull,
		0x3FCAECBEB8FD9ACCull,0x3FCABAD0D80E36CEull,0x3FCA88DEB61B4AA3ull,0x3FCA56E85B17B649ull,0x3FCA24EDCEF705CEull,0x3FC9F2EF19AD7006ull,0x3FC9C0EC432FD54Bull,0x3FC98EE55373BE37ull,
		0x3FC95CDA526F5A5Full,0x3FC92ACB48197F10ull,0x3FC8F8B83C69A60Bull,0x3FC8C6A13757EC3Dull,0x3FC8948640DD1080ull,0x3FC8626760F27250ull,0x3FC830449F92108Dull,0x3FC7FE1E04B6882Dull,
		0x3FC7CBF3985B1301ull,0x3FC799C5627B8669ull,0x3FC767936B14520Full,0x3FC7355DBA227EA6ull,0x3FC7032457A3ACA1ull,0x3FC6D0E74B9612EDull,0x3FC69EA69DF87DAEull,0x3FC66C6256CA4CF9ull,
		0x3FC63A1A7E0B738Aull,0x3FC607CF1BBC7583ull,0x3FC5D58037DE6724ull,0x3FC5A32DDA72EB85ull,0x3FC570D80B7C3350ull,0x3FC53E7ED2FCFB7Aull,0x3FC50C2238F88BFDull,0x3FC4D9C24572B693ull,
		0x3FC4A75F006FD56Dull,0x3FC474F871F4C9EEull,0x3FC4428EA206FB64ull,0x3FC4102198AC55BFull,0x3FC3DDB15DEB4851ull,0x3FC3AB3DF9CAC47Dull,0x3FC378C774523C77ull,0x3FC3464DD589A1FDull,
		0x3FC313D12579650Cull,0x3FC2E1516C2A729Aull,0x3FC2AECEB1A63351ull,0x3FC27C48FDF68A45ull,0x3FC249C05925D3ACull,0x3FC21734CB3EE399ull,0x3FC1E4A65C4D04B5ull,0x3FC1B215145BF6F1ull,
		0x3FC17F80FB77EE46ull,0x3FC14CEA19AD9168ull,0x3FC11A507709F880ull,0x3FC0E7B41B9AABE5ull,0x3FC0B5150F6DA2D1ull,0x3FC082735A91421Aull,0x3FC04FCF05145AECull,0x3FC01D281706297Eull,
		0x3FBFD4FD30ECA794ull,0x3FBF6FA522E9D08Dull,0x3FBF0A481424B937ull,0x3FBEA4E614BF18B8ull,0x3FBE3F7F34DB6F78ull,0x3FBDDA13849D048Full,0x3FBD74A31427E339ull,0x3FBD0F2DF3A0D83Dull,
		0x3FBCA9B4332D6F61ull,0x3FBC4435E2F3F0D5ull,0x3FBBDEB3131B5EA1ull,0x3FBB792BD3CB7217ull,0x3FBB13A0352C993Bull,0x3FBAAE104767F434ull,0x3FBA487C1AA752BAull,0x3FB9E2E3BF153181ull,
		0x3FB97D4744DCB7AAull,0x3FB917A6BC29B42Cull,0x3FB8B20235289B45ull,0x3FB84C59C00683E4ull,0x3FB7E6AD6CF12518ull,0x3FB780FD4C16D37Eull,0x3FB71B496DA67EA7ull,0x3FB6B591E1CFAE90ull,
		0x3FB64FD6B8C28103ull,0x3FB5EA1802AFA70Aull,0x3FB58455CFC8625Dull,0x3FB51E90303E82C8ull,0x3FB4B8C73444639Bull,0x3FB452FAEC0CE917ull,0x3FB3ED2B67CB7DD8ull,0x3FB38758B7B41040ull,
		0x3FB32182EBFB0FE9ull,0x3FB2BBAA14D56B08ull,0x3FB255CE42788BDEull,0x3FB1EFEF851A5624ull,0x3FB18A0DECF12474ull,0x3FB124298A33C5B6ull,0x3FB0BE426D197A8Bull,0x3FB05858A5D9F2BAull,
		0x3FAFE4D8895A952Eull,0x3FAF18FAB39810E6ull,0x3FAE4D17EADE3408ull,0x3FAD81304F9FA3A4ull,0x3FACB544024FC940ull,0x3FABE9532362CDB2ull,0x3FAB1D5DD34D93F4ull,0x3FAA51643285B3F9ull,
		0x3FA9856661817583ull,0x3FA8B96480B7CAF9ull,0x3FA7ED5EB0A04C3Dull,0x3FA7215511B3317Eull,0x3FA65547C4694E11ull,0x3FA58936E93C0B44ull,0x3FA4BD22A0A56333ull,0x3FA3F10B0B1FDB9Eull,
		0x3FA324F0492680BCull,0x3FA258D27B34E012ull,0x3FA18CB1C1C70344ull,0x3FA0C08E3D596AEEull,0x3F9FE8D01CD212E9ull,0x3F9E507EAAE67BB9ull,0x3F9CB82865EB9D38ull,0x3F9B1FCD8EDDC8E3ull,
		0x3F99876E66BA0A6Dull,0x3F97EF0B2E7E1D67ull,0x3F9656A4272862EBull,0x3F94BE3991B7D741ull,0x3F9325CBAF2C0788ull,0x3F918D5AC085075Eull,0x3F8FE9CE0D86CD12ull,0x3F8CB8E185D04D38ull,
		0x3F8987F06BE96143ull,0x3F8656FB41D59582ull,0x3F83260289991BCDull,0x3F7FEA0D8A716DB2ull,0x3F798810ED734B00ull,0x3F73261040431C28ull,0x3F6988190DD9A6B3ull,0x3F59881B15F37BB4ull
	};

#endif	/* #ifndef radix1008_avx_negadwt_consts_included */
