/*====================================================================*
 *
 *   Copyright (c) 2013 Qualcomm Atheros, Inc.
 *
 *   All rights reserved.
 *
 *   Redistribution and use in source and binary forms, with or
 *   without modification, are permitted (subject to the limitations
 *   in the disclaimer below) provided that the following conditions
 *   are met:
 *
 *   * Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *
 *   * Redistributions in binary form must reproduce the above
 *     copyright notice, this list of conditions and the following
 *     disclaimer in the documentation and/or other materials
 *     provided with the distribution.
 *
 *   * Neither the name of Qualcomm Atheros nor the names of
 *     its contributors may be used to endorse or promote products
 *     derived from this software without specific prior written
 *     permission.
 *
 *   NO EXPRESS OR IMPLIED LICENSES TO ANY PARTY'S PATENT RIGHTS ARE
 *   GRANTED BY THIS LICENSE. THIS SOFTWARE IS PROVIDED BY THE
 *   COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
 *   IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *   WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 *   PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 *   OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *   NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *   LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 *   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 *   OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *--------------------------------------------------------------------*/

/*====================================================================*
 *
 *   signed FlashDevice2 (struct plc * plc, uint32_t options);
 *
 *   plc.h
 *
 *   flash a QCA7420 device; force a reset because a reset is not
 *   automatic;
 *
 *   Contributor(s):
 *      Charles Maier
 *
 *--------------------------------------------------------------------*/

#ifndef FLASHDEVICE2_SOURCE
#define FLASHDEVICE2_SOURCE

#include "../plc/plc.h"

signed FlashDevice2 (struct plc * plc, uint32_t options)

{
	char firmware [256];
	if ((plc->NVM.file != -1) && (plc->PIB.file == -1))
	{
		/* do not allow a firmware only flash */
		return (-1);
	}
	if (plc->SFT.file != -1)
	{
		if (FlashSoftloader (plc, options))
		{
			return (-1);
		}
	}
	if (plc->NVM.file != -1)
	{
		if (FlashFirmware (plc, options))
		{
			return (-1);
		}
		sleep (5);
		if (WaitForStart (plc, firmware, sizeof (firmware)) == 0)
		{
			if (strcmp (firmware, "BootLoader"))
			{
				return (0);
			}
		}
	}
	else if (plc->PIB.file != -1)
	{
		if (FlashParameters (plc, options))
		{
			return (-1);
		}
	}
	if (ResetDevice (plc))
	{
		return (-1);
	}
	sleep (5);
	if (WaitForStart (plc, firmware, sizeof (firmware)))
	{
		return (-1);
	}
	return (0);
}

#endif

