% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cosine_heatmap.R
\name{plot_cosine_heatmap}
\alias{plot_cosine_heatmap}
\title{Plot cosine similarity heatmap}
\usage{
plot_cosine_heatmap(
  cos_sim_matrix,
  col_order = NA,
  row_order = NA,
  cluster_rows = TRUE,
  cluster_cols = FALSE,
  method = "complete",
  plot_values = FALSE
)
}
\arguments{
\item{cos_sim_matrix}{Matrix with pairwise cosine similarities.
Result from \code{\link{cos_sim_matrix}}}

\item{col_order}{Character vector with the desired order of the columns names for plotting. Optional.}

\item{row_order}{Character vector with the desired order of the row names for plotting. Optional.}

\item{cluster_rows}{Hierarchically cluster rows based on eucledian distance. Default = TRUE.}

\item{cluster_cols}{Hierarchically cluster cols based on eucledian distance. Default = FALSE.}

\item{method}{The agglomeration method to be used for hierarchical clustering. This should be one of
"ward.D", "ward.D2", "single", "complete", "average" (= UPGMA), "mcquitty" (= WPGMA), "median" (= WPGMC)
or "centroid" (= UPGMC). Default = "complete".}

\item{plot_values}{Plot cosine similarity values in heatmap. Default = FALSE.}
}
\value{
Heatmap with cosine similarities
}
\description{
Plot pairwise cosine similarities in a heatmap.
}
\examples{

## See the 'mut_matrix()' example for how we obtained the mutation matrix:
mut_mat <- readRDS(system.file("states/mut_mat_data.rds",
  package = "MutationalPatterns"
))

## Get signatures
signatures <- get_known_signatures()

## Calculate the cosine similarity between each signature and each 96 mutational profile
cos_matrix <- cos_sim_matrix(mut_mat, signatures)


## Plot the cosine similarity between each signature and each sample with hierarchical
## clustering of samples and signatures.
plot_cosine_heatmap(cos_matrix, cluster_rows = TRUE, cluster_cols = TRUE)

## In the above example, clustering is performed on the similarities of the samples with
## the signatures. It's also possible to cluster the signatures and samples on their (96) profile.
## This will generally give better results
## If you use the same signatures for different analyses,
## then their order will also be consistent.
hclust_cosmic <- cluster_signatures(signatures, method = "average")
cosmic_order <- colnames(signatures)[hclust_cosmic$order]
hclust_samples <- cluster_signatures(mut_mat, method = "average")
sample_order <- colnames(mut_mat)[hclust_samples$order]
## Plot the cosine heatmap using this given signature order.
plot_cosine_heatmap(cos_matrix,
  cluster_rows = FALSE, cluster_cols = FALSE,
  row_order = sample_order, col_order = cosmic_order
)

## You can also plot the similarity of samples with eachother
cos_matrix <- cos_sim_matrix(mut_mat, mut_mat)
plot_cosine_heatmap(cos_matrix, cluster_rows = TRUE, cluster_cols = TRUE)


## It's also possible to add the actual values in the heatmap.
plot_cosine_heatmap(cos_matrix, cluster_rows = TRUE, cluster_cols = TRUE, plot_values = TRUE)
}
\seealso{
\code{\link{mut_matrix}},
\code{\link{cos_sim_matrix}}
}
