% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.git_repository}
\alias{plot.git_repository}
\title{Plot commits over time}
\usage{
\method{plot}{git_repository}(
  x,
  breaks = c("month", "year", "quarter", "week", "day"),
  main = NULL,
  ...
)
}
\arguments{
\item{x}{The repository to plot}

\item{breaks}{Default is \code{month}. Change to year, quarter,
week or day as necessary.}

\item{main}{Default title for the plot is "Commits on repo:" and
repository workdir basename. Supply a new title if you desire one.}

\item{...}{Additional arguments affecting the plot}
}
\description{
Plot commits over time
}
\examples{
\dontrun{
## Initialize repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- clone("https://github.com/ropensci/git2r.git", path)

## Plot commits
plot(repo)
}
}
