% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/httr.r
\docType{package}
\name{httr-package}
\alias{httr}
\alias{httr-package}
\title{\pkg{httr} makes http easy.}
\description{
\code{httr} is organised around the six most common http verbs:
\code{\link[=GET]{GET()}}, \code{\link[=PATCH]{PATCH()}},
\code{\link[=POST]{POST()}}, \code{\link[=HEAD]{HEAD()}},
\code{\link[=PUT]{PUT()}}, and \code{\link[=DELETE]{DELETE()}}.
}
\details{
Each request returns a \code{\link[=response]{response()}} object which provides
easy access to status code, cookies, headers, timings, and other useful
info.  The content of the request is available as a raw vector
(\code{\link[=content]{content()}}), character vector (\code{\link[=text_content]{text_content()}}),
or parsed into an R object (\code{\link[=parsed_content]{parsed_content()}}), currently for
html, xml, json, png and jpeg).

Requests can be modified by various config options like
\code{\link[=set_cookies]{set_cookies()}}, \code{\link[=add_headers]{add_headers()}},
\code{\link[=authenticate]{authenticate()}}, \code{\link[=use_proxy]{use_proxy()}},
\code{\link[=verbose]{verbose()}}, and \code{\link[=timeout]{timeout()}}

httr supports OAuth 1.0 and 2.0. Use \code{\link[=oauth1.0_token]{oauth1.0_token()}} and
\code{\link[=oauth2.0_token]{oauth2.0_token()}} to get user tokens, and
\code{\link[=sign_oauth1.0]{sign_oauth1.0()}} and \code{\link[=sign_oauth2.0]{sign_oauth2.0()}} to sign
requests. The demos directory has twelve demos of using OAuth: four for 1.0
(linkedin, twitter, vimeo, and yahoo) and eight for 2.0 (azure, facebook,
github, google, linkedin, reddit, yahoo, and yelp).
}
\seealso{
Useful links:
\itemize{
  \item \url{https://httr.r-lib.org/}
  \item \url{https://github.com/r-lib/httr}
  \item Report bugs at \url{https://github.com/r-lib/httr/issues}
}

}
\author{
\strong{Maintainer}: Hadley Wickham \email{hadley@posit.co}

Other contributors:
\itemize{
  \item Posit, PBC [copyright holder, funder]
}

}
\keyword{internal}
