## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(httr2)

## -----------------------------------------------------------------------------
req <- request("https://httpbin.org/get")
req

## -----------------------------------------------------------------------------
req %>% req_dry_run()

## -----------------------------------------------------------------------------
req %>%
  req_headers(
    Name = "Hadley", 
    `Shoe-Size` = "11", 
    Accept = "application/json"
  ) %>% 
  req_dry_run()

## -----------------------------------------------------------------------------
req %>%
  req_body_json(list(x = 1, y = "a")) %>% 
  req_dry_run()

## -----------------------------------------------------------------------------
req %>%
  req_body_form(x = "1", y = "a") %>% 
  req_dry_run()

## -----------------------------------------------------------------------------
req %>%
  req_body_multipart(x = "1", y = "a") %>% 
  req_dry_run()

## -----------------------------------------------------------------------------
req <- request("https://httpbin.org/json")
resp <- req %>% req_perform()
resp

## -----------------------------------------------------------------------------
resp %>% resp_raw()

## -----------------------------------------------------------------------------
resp %>% resp_status()
resp %>% resp_status_desc()

## -----------------------------------------------------------------------------
resp %>% resp_headers()
resp %>% resp_header("Content-Length")

## -----------------------------------------------------------------------------
resp %>% resp_header("ConTEnT-LeNgTH")

## -----------------------------------------------------------------------------
resp %>% resp_body_json() %>% str()

## ---- error = TRUE------------------------------------------------------------
request("https://httpbin.org/status/404") %>% req_perform()
request("https://httpbin.org/status/500") %>% req_perform()

