% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variableKey.R
\name{long2wide}
\alias{long2wide}
\title{convert a key object from long to wide format}
\usage{
long2wide(
  keylong,
  na.strings = c("\\\\.", "", "\\\\s+", "N/A"),
  missSymbol = "."
)
}
\arguments{
\item{keylong}{A variable key in the long format}

\item{na.strings}{Strings to be treated as missings in value_new}

\item{missSymbol}{Default is ".", character to insert in value when R NA is found.}
}
\value{
A wide format variable key
}
\description{
##' This is not flexible, assumes columns are named in our canonical
style, which means the columns are named c("name_old", "name_new",
"class_old", "class_new", "value_old", "value_new").
}
\examples{
mydf.path <- system.file("extdata", "mydf.csv", package = "kutils")
mydf <- read.csv(mydf.path, stringsAsFactors=FALSE)
## A wide key we are trying to match:
mydf.key <- keyTemplate(mydf, long = FALSE, sort = TRUE)
mydf.key["x4", "missings"] <- "999"
## A long key we will convert next
mydf.keylong <- keyTemplate(mydf, long = TRUE, sort = TRUE)
mydf.keylong[mydf.keylong[ , "name_old"] == "x4" &
    mydf.keylong[ , "value_old"] == "999", "missings"] <- "999"
mydf.long2wide <- long2wide(mydf.keylong)
all.equal(mydf.key, mydf.long2wide)

mydf.keylong.path <- system.file("extdata", "mydf.key_long.csv", package = "kutils")
mydf.keylong <- keyImport(mydf.keylong.path)
mydf.keywide <- long2wide(mydf.keylong)
mydf.keylong2 <- wide2long(mydf.keywide)
## Is error if following not TRUE
all.equal(mydf.keylong2, mydf.keylong)

}
\author{
Paul Johnson <pauljohn@ku.edu>
}
