# 2024-11-11 Triage Log

Regressions primarily in doc builds. No significant changes in cycle or max-rss
counts.

Triage done by **@simulacrum**.
Revision range: [27e38f8f..d4822c2d](https://perf.rust-lang.org/?start=27e38f8fc7efc57b75e9a763d7a0ee44822cd5f7&end=d4822c2d84c242cc7403118b50c571464f38ef8f&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.2%, 1.0%]   | 61    |
| Regressions ❌ <br /> (secondary)  | 0.9%  | [0.2%, 1.5%]   | 30    |
| Improvements ✅ <br /> (primary)   | -2.9% | [-5.0%, -0.6%] | 7     |
| Improvements ✅ <br /> (secondary) | -1.5% | [-5.0%, -0.2%] | 28    |
| All ❌✅ (primary)                 | 0.1%  | [-5.0%, 1.0%]  | 68    |

1 Regressions, 1 Improvements, 4 Mixed; 1 of them in rollups
47 artifact comparisons made in total

#### Regressions

Clean middle generics using paren sugar if trait has `#[rustc_paren_sugar]` [#132697](https://github.com/rust-lang/rust/pull/132697) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4d215e2426d52ca8d1af166d5f6b5e172afbff67&end=116fc31c5c82b7767c87101164a1afa3faea97fd&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2% | [0.1%, 0.4%] | 8     |
| Regressions ❌ <br /> (secondary)  | 0.3% | [0.2%, 0.4%] | 16    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.2% | [0.1%, 0.4%] | 8     |

Doc-only regressions, no fix directly planned (prioritizing code clarity), but
inspired some unrelated cleanup in
https://github.com/rust-lang/rust/pull/132886.

rustdoc-search: simplify rules for generics and type params [#127589](https://github.com/rust-lang/rust/pull/127589) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=71042b4b201a432b426304f511b3169850ed8923&end=d4822c2d84c242cc7403118b50c571464f38ef8f&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.1%, 0.5%]   | 15    |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.1%, 0.5%]   | 19    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -2.4% | [-2.4%, -2.4%] | 1     |
| All ❌✅ (primary)                 | 0.2%  | [0.1%, 0.5%]   | 15    |

Doc-only regressions, likely genuine given the change.

#### Improvements

Only disable cache if predicate has opaques within it [#132625](https://github.com/rust-lang/rust/pull/132625) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8549802939cd01111c46e34a7b67cb1933977af9&end=c07aa1e17199e27f6f7ac8f3307bca7bda0084b6&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -2.7% | [-5.0%, -0.2%] | 7     |
| Improvements ✅ <br /> (secondary) | -3.0% | [-5.1%, -0.3%] | 10    |
| All ❌✅ (primary)                 | -2.7% | [-5.0%, -0.2%] | 7     |

#### Mixed

Add new unstable feature `const_eq_ignore_ascii_case` [#131721](https://github.com/rust-lang/rust/pull/131721) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e1fb28856267e3cbfd1ea479e666ce25d67fea29&end=279604832887abeaea0cb31c20590c43dea497ae&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.7%, -0.1%] | 4     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.3% | [-0.7%, 0.2%]  | 5     |

Probably mostly luck of some kind, change itself is library-only.

Emit warning when calling/declaring functions with unavailable vectors. [#132173](https://github.com/rust-lang/rust/pull/132173) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=303fc0527aea5c7e9bbef97da926639e1ade3399&end=7660aed73d5233fdd1ff2651fc8a6acab1b61691&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.2%, 1.0%]   | 36    |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.2%, 0.9%]   | 6     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.4%, -0.4%] | 1     |
| Improvements ✅ <br /> (secondary) | -0.1% | [-0.1%, -0.1%] | 1     |
| All ❌✅ (primary)                 | 0.5%  | [-0.4%, 1.0%]  | 37    |

Regression, but a bunch of optimization work already went into it (see
https://github.com/rust-lang/rust/pull/132173#issuecomment-2466642549).

Rollup of 6 pull requests [#132831](https://github.com/rust-lang/rust/pull/132831) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7660aed73d5233fdd1ff2651fc8a6acab1b61691&end=668959740f97e7a22ae340742886d330ab63950f&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 1.4%  | [1.3%, 1.5%]   | 6     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.7% | [-1.4%, -0.2%] | 13    |
| All ❌✅ (primary)                 | -     | -              | 0     |

Queued up one trial build. Likely a real regression, but not necessarily worth
digging deeper given limited impact (few benchmarks).
