# 2023-06-21 Triage Log

Fairly positive week with very few regressions and some decent (albeit incremental) improvements. The most widespread gains came from some standard library improvements which are not a particularly common cause of large improvements in compiler performance. Overall a large chunk of the perf test suite showed an average of 0.6% improvement.

Triage done by **@rylev**.
Revision range: [4bd4e2e..b9d608c](https://perf.rust-lang.org/?start=4bd4e2ea824f4f458cae8917047ebb6b88853fe6&end=b9d608c979ad3c0700f9f0237a8c12feb0ba44fb&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.4%  | [0.5%, 3.6%]    | 16    |
| Regressions ❌ <br /> (secondary)  | 1.0%  | [0.2%, 3.5%]    | 29    |
| Improvements ✅ <br /> (primary)   | -0.8% | [-7.8%, -0.2%]  | 157   |
| Improvements ✅ <br /> (secondary) | -2.9% | [-48.3%, -0.3%] | 84    |
| All ❌✅ (primary)                 | -0.6% | [-7.8%, 3.6%]   | 173   |


3 Regressions, 7 Improvements, 4 Mixed; 3 of them in rollups
51 artifact comparisons made in total

#### Regressions

Rollup of 7 pull requests [#112625](https://github.com/rust-lang/rust/pull/112625) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0b475c705f36fb3b0a63994b92f2bbd2f5865b07&end=8c74a5d27c644a0f7a22bb2fa8dd3ff8257bc220&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.2%, 0.4%] | 4     |
| Regressions ❌ <br /> (secondary)  | 0.2% | [0.2%, 0.2%] | 1     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.2%, 0.4%] | 4     |
- Seems like this was a blip in the bitmaps test which corrected itself in the next run. 


Add `AliasKind::Weak` for type aliases. [#108860](https://github.com/rust-lang/rust/pull/108860) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=670a0edaa9d80683df8db81554890710e79f8024&end=0cc541e4b2eb957e71490cf44df1ac09f6d18132&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.2%, 0.5%] | 8     |
| Regressions ❌ <br /> (secondary)  | 0.4% | [0.2%, 0.8%] | 7     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.2%, 0.5%] | 8     |
- Poked author and reviewer for thoughts on small regressions


CI: merge `mingw` test CI jobs [#112645](https://github.com/rust-lang/rust/pull/112645) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=939786223f2d36b1af62e27e9a7a54bae6e30f3f&end=2d0aa57684e10f7b3d3fe740ee18d431181583ad&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.8% | [0.7%, 0.8%] | 3     |
| Regressions ❌ <br /> (secondary)  | 0.7% | [0.6%, 0.7%] | 2     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.8% | [0.7%, 0.8%] | 3     |
- Noise as Linux was impacted


#### Improvements

Introduce a minimum CGU size in non-incremental builds. [#112448](https://github.com/rust-lang/rust/pull/112448) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6330daade9766bbf896495898c2347dc3be6da17&end=fa8762b7b6c2b75d6c83fb011ee8fa4874168829&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -               | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -               | 0     |
| Improvements ✅ <br /> (primary)   | -2.1% | [-7.8%, -0.3%]  | 19    |
| Improvements ✅ <br /> (secondary) | -8.5% | [-45.9%, -0.4%] | 22    |
| All ❌✅ (primary)                 | -2.1% | [-7.8%, -0.3%]  | 19    |


Don't drain-on-drop in DrainFilter impls of various collections. [#104455](https://github.com/rust-lang/rust/pull/104455) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8c74a5d27c644a0f7a22bb2fa8dd3ff8257bc220&end=6ee4265ca6a7f037237974eeb66e8303282c6a4c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.2%, 1.2%]   | 3     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-1.8%, -0.1%] | 35    |
| Improvements ✅ <br /> (secondary) | -0.5% | [-1.1%, -0.2%] | 14    |
| All ❌✅ (primary)                 | -0.4% | [-1.8%, 1.2%]  | 38    |


optimize slice::Iter::fold [#106343](https://github.com/rust-lang/rust/pull/106343) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5a65be815211a059b08ee3b786583308377372fa&end=4996b56ba9647d149265d03dcbd9ab837af3a1bb&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7%  | [0.4%, 1.1%]   | 5     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.4%, -0.2%] | 87    |
| Improvements ✅ <br /> (secondary) | -0.3% | [-1.2%, -0.1%] | 24    |
| All ❌✅ (primary)                 | -0.2% | [-0.4%, 1.1%]  | 92    |


Rollup of 7 pull requests [#112716](https://github.com/rust-lang/rust/pull/112716) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6bba061467f7c2cab04b262b95eb67bf89265587&end=670a0edaa9d80683df8db81554890710e79f8024&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.4%, -0.4%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.4%, -0.2%] | 4     |
| All ❌✅ (primary)                 | -0.4% | [-0.4%, -0.4%] | 2     |


Rollup of 5 pull requests [#112755](https://github.com/rust-lang/rust/pull/112755) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0c2c243342ec2a2427f0624fac5ac59f0ee6fbcd&end=76fb0e38087cb8fcc6de5fe2ce347e939dfdb0bd&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.8% | [-1.8%, -0.2%] | 16    |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.8% | [-1.8%, -0.2%] | 16    |


Rollup of 6 pull requests [#112774](https://github.com/rust-lang/rust/pull/112774) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2d0aa57684e10f7b3d3fe740ee18d431181583ad&end=f217411bacbe943ead9dfca93a91dff0753c2a96&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.8% | [-0.8%, -0.7%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.7% | [-0.7%, -0.7%] | 2     |
| All ❌✅ (primary)                 | -0.8% | [-0.8%, -0.7%] | 3     |


new solver proof tree generation [#112351](https://github.com/rust-lang/rust/pull/112351) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3c9e0705ba0c1c845fe7cdbd0bdf4a914f49cc8e&end=18a6d911caba59605eb03db1452848a85d2e5879&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.8%, -0.2%] | 9     |
| Improvements ✅ <br /> (secondary) | -1.2% | [-1.6%, -0.5%] | 8     |
| All ❌✅ (primary)                 | -0.5% | [-0.8%, -0.2%] | 9     |


#### Mixed

Add support for targets without unwinding in `mir-opt`, and improve `--bless` for it [#112418](https://github.com/rust-lang/rust/pull/112418) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7b0eac438ace0ba305b4633328b00474fbbf5120&end=afa9fef70904bee316d5a73275397d7c4e7c8c4b&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.3%]   | 3     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -1.3% | [-1.3%, -1.3%] | 1     |
| All ❌✅ (primary)                 | 0.3%  | [0.2%, 0.3%]   | 3     |
- Noise returning to a steady state


Ignore the always part of #[inline(always)] in MIR inlining [#112294](https://github.com/rust-lang/rust/pull/112294) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6a94e87a54ecf2df307c65af2dbc2effb3a525b8&end=6bba061467f7c2cab04b262b95eb67bf89265587&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.7%  | [1.2%, 2.5%]   | 8     |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.2%, 1.4%]   | 7     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-3.0%, -0.2%] | 61    |
| Improvements ✅ <br /> (secondary) | -0.4% | [-1.0%, -0.2%] | 18    |
| All ❌✅ (primary)                 | -0.1% | [-3.0%, 2.5%]  | 69    |
- From the author: "There are some notable regressions, and I think we might be able to claw those back by turning `#[inline(always)]` into a stronger hint. But I think this PR stands decently on its own as a tidy simplification."


Remove `box_free` lang item [#100036](https://github.com/rust-lang/rust/pull/100036) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e1c29d137dd779dcfce447d8d149ee6b8e9bdf78&end=a8a29070f07e47a244c8199ad582f93172019743&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.2%  | [1.0%, 1.7%]   | 4     |
| Regressions ❌ <br /> (secondary)  | 1.7%  | [1.1%, 3.4%]   | 5     |
| Improvements ✅ <br /> (primary)   | -0.6% | [-0.6%, -0.6%] | 2     |
| Improvements ✅ <br /> (secondary) | -2.5% | [-4.4%, -1.4%] | 4     |
| All ❌✅ (primary)                 | 0.6%  | [-0.6%, 1.7%]  | 6     |
- Waiting on the author and reviewer to give their thoughts.


make mir dataflow graphviz dumps opt-in [#112617](https://github.com/rust-lang/rust/pull/112617) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f217411bacbe943ead9dfca93a91dff0753c2a96&end=c911e085144324110b4b51b333e71444861b0d17&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6%  | [0.6%, 0.7%]   | 3     |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.6%, 0.6%]   | 1     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.6%, -0.4%] | 6     |
| All ❌✅ (primary)                 | 0.6%  | [0.6%, 0.7%]   | 3     |
- Regressions are noise
