/* 
 * vflmklib.c 
 * - commn functions used in vflmkXXX.c
 *
 *
 * by Hirotsugu Kakugawa
 *
 *  10 May 2001
 *  22 Jul 2005  Enhanced file search.
 */
/*
 * Copyright (C) 2001-2005  Hirotsugu Kakugawa. 
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 */


#include "config.h"
#include "with.h"
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <unistd.h>
#include <sys/param.h>
#include <sys/time.h>

#ifdef WITH_KPATHSEA
# include  "kpathsea/kpathsea.h"
#endif

#include  "VFlib-3_6.h"
#include  "VFsys.h"
#include  "vflibcap.h"
#include  "fsearch.h"



char*
copy_cmdline(int xargc, char **xargv)
{
  int   i, t;
  char  *s, *p;

  t = 1;
  for (i = 0; i < xargc; i++)
    t = t + strlen(xargv[i]) + 1;
  if ((s = malloc(t)) == NULL){
    fprintf(stderr, "no memory.\n");
    exit(1);
  }
  
  p = s;
  for (i = 0; i < xargc; i++){
    strcpy(p, xargv[i]);
    p += strlen(xargv[i]);
    *(p++) = ' ';
  }
  p[t-1] = '\0';

  return s;
}


void 
banner(char *name, char *prog, char *cline)
{
  char  host[256], ts[256], *p;
  time_t   t;

  if (gethostname(host, sizeof(host)) < 0)
    strcpy(host, "???");
  t = time(NULL);

  strcpy(ts, asctime(localtime(&t)));
  if ((p = strchr(ts, '\n')) != NULL)
    *p = '\0';

  printf(";; -------------------------------------------------------\n");
  printf(";; *** %s ***\n", name);
  printf(";; Generated by %s\n", prog);
  printf(";; at %s on %s\n", ts, host);
  printf(";; Commandline: %s\n", cline);
  printf("\n");
}

char*
x_strdup(char *s)
{
  char  *p;

  if (s == NULL){
    fprintf(stderr, "internal error.");
    exit(1);
  }

  p = malloc(strlen(s) + 1);
  if (p == NULL){
    fprintf(stderr, "no memory.");
    exit(1);
  }
  
  strcpy(p, s);
  return p;
}

char*
check_font_exist(char *file, char **dirs, int ndirs, int kptype, char **ext)
{
  int  i, l, j, y;
  char  path[MAXPATHLEN], *p, **e;
  char *e0[] = { "", NULL };

  if (ndirs == 0)
    return 0;  /* may or may not exist */

  e = ext;
  if (e == NULL)
    e = e0;

  for (i = 0; i < ndirs; i++){
    if ((strcmp(dirs[i], "TEXMF") == 0)
	|| (strcmp(dirs[i], "KPATHSEA") == 0)
	|| (strcmp(dirs[i], "texmf") == 0)
	|| (strcmp(dirs[i], "kpathsea") == 0)){
      p = kpse_find_file(file, kptype, 0);
      if ((p != NULL) && (access(p, R_OK) >= 0)){
	return  x_strdup(file);    /* exist */
      } else { 
	for (j = 0; e[j] != NULL; j++){
	  sprintf(path, "%s%s", file, e[j]);
	  /* check as it is */
	  p = kpse_find_file(path, kptype, 0);
	  if ((p != NULL) && (access(p, R_OK) >= 0))
	    return  x_strdup(path);    /* exist */
	  /* check lower case */
	  for (y = 0; path[y] != '\0'; y++)
	    path[y] = tolower(path[y]);
	  p = kpse_find_file(path, kptype, 0);
	  if ((p != NULL) && (access(p, R_OK) >= 0))
	    return  x_strdup(path);    /* exist */
	  /* check upper case */
	  for (y = 0; path[y] != '\0'; y++)
	    path[y] = toupper(path[y]);
	  p = kpse_find_file(path, kptype, 0);
	  if ((p != NULL) && (access(p, R_OK) >= 0))
	    return  x_strdup(path);    /* exist */
	}
      }
      return NULL;
    } else {
      for (j = 0; e[j] != NULL; j++){
	sprintf(path, "%s", dirs[i]);
	l = strlen(dirs[i]);
	if ((l >= 2) && (dirs[i][l-2] == '/') && (dirs[i][l-1] == '/')){
	  sprintf(&path[l-2], "/%s", file);
	} else if ((l >= 2) && (dirs[i][l-2] != '/') && (dirs[i][l-1] == '/')){
	  sprintf(&path[l-1], "/%s", file);
	} else {
	  sprintf(&path[l], "/%s", file);
	}
	strcat(path, e[j]);
	if (access(path, R_OK) >= 0)
	  return  x_strdup(path);    /* exist */
      }
    }
  }
  
  return NULL;  /* not exist */
}


void
check_argc(int argc)
{
  if (argc == 0){
    fprintf(stderr,"Illegal command line argument\n");
    fprintf(stderr,"Use '--help' option for help\n");
    exit(1);
  }
}


int
map_need_tfm(char *fontclass)
{
  int  i;
  static char *db[] = {
    "type1", 
    "vf", 
    NULL};
  
  for (i = 0; db[i] != NULL; i++){
    if (strcmp(fontclass, db[i]) == 0)
      return 1;
  }
  return 0;  
}
