
#macro frameDefaults()
  #declare playerDamaged = 0;
  #declare playerWalkHeight = 0.0;
  #declare playerLocation = z*-2.667;
#end




#if (playerWinning)
  #local c=playerAnimationClock;
  frameDefaults()
  #switch (c)
    #case (0)
      #declare W=0;
    #break
    #case (1)
      #declare W=0.25;
    #break
    #case (2)
      #declare W=0.75;
    #break
  #end 

  #declare leftLowerArmAngle  = <   30-45*W,  75-75*W,   0-30*W>;
  #declare leftArmAngle       = <   75-60*W, -30+40*W, -15-30*W>;
  #declare rightLowerArmAngle = <   30-45*W, -75+75*W,   0+30*W>;
  #declare rightArmAngle      = <   75-60*W,  30-40*W,  15+30*W>;

  #declare rightLowerLegAngle = <    0-25*W,   0     ,   0     >;
  #declare rightLegAngle      = <    0+15*W,  15     ,   0     >;
  #declare leftLowerLegAngle  = <    0-25*W,   0     ,   0     >;
  #declare leftLegAngle       = <    0+15*W, -15     ,   0     >;

  #declare rightFootAngle     = <    0     ,   0     ,   0     >;
  #declare leftFootAngle      = <    0     ,   0     ,   0     >;

  #declare headAngle          = <   10-10*W,   0     ,   0     >;
  #declare bodyAngle          = <   10-10*W,   0     ,   0     >;

  #declare playerLocation=(-2.567-0.1*W)*z;
#end


#if (playerLosing)
  #local c=playerAnimationClock;
  frameDefaults()
  #declare leftLowerArmAngle  = <  -15,   0, -30>;
  #declare leftArmAngle       = <    0,   0, -60>;
  #declare rightLowerArmAngle = <  -15,   0,  30>;
  #declare rightArmAngle      = <    0,   0,  60>;

  #declare rightLowerLegAngle = < - 25,   0,  0>;
  #declare rightLegAngle      = < + 25,  15,  0>;
  #declare leftLowerLegAngle  = < - 25,   0,  0>;
  #declare leftLegAngle       = < + 25, -15,  0>;

  #declare rightFootAngle     = <    0,   0,  0>;
  #declare leftFootAngle      = <    0,   0,  0>;

  #switch (c)
     #case (0) 
       #declare headAngle          = <  -10,   0,  0>;
     #break
     #case (1) 
       #declare headAngle          = <  -10,  15,  0>;
     #break
     #case (2) 
       #declare headAngle          = <  -10, -15,  0>;
     #break
  #end
  #declare bodyAngle          = <  -10,   0,  0>;
#end


#if (playerKilled)
  frameDefaults()
  #declare playerDamaged = 1;
  #declare playerWalkHeight = -1.0;

  #declare leftLowerArmAngle  = <  -15,   0, -30>;
  #declare leftArmAngle       = <  -15, -20, -45>;
  #declare rightLowerArmAngle = <  -15,   0,  30>;
  #declare rightArmAngle      = <  -15,  20,  45>;

  #declare rightLowerLegAngle = < - 25,   0,  0>;
  #declare rightLegAngle      = < + 90,  15,  0>;
  #declare leftLowerLegAngle  = < - 25,   0,  0>;
  #declare leftLegAngle       = < + 90, -15,  0>;

  #declare rightFootAngle     = <    0,   0,  0>;
  #declare leftFootAngle      = <    0,   0,  0>;

  #declare headAngle          = <    0,   0, 10>;
  #declare bodyAngle          = <   15,   0,  0>;
#end


#if (playerWalking)
  #local c=playerAnimationClock;
  frameDefaults()
  //
  // lots of trigonometrical functions
  //
  #declare COS = cos(radians(c/4.0*360));
  #declare SIN = sin(radians(c/4.0*360));

  #if (COS > 0.0)
    #declare PCOS = COS;
    #declare MCOS = 0.0;
  #else
    #declare PCOS = 0.0;
    #declare MCOS = COS;
  #end

  #if (SIN > 0.0)
    #declare PSIN = SIN;
    #declare MSIN = 0.0;
  #else
    #declare PSIN = 0.0;
    #declare MSIN = SIN;
  #end

  #declare P2SIN=PSIN*PSIN;
  #declare M2SIN=-MSIN*MSIN;
  #declare P2COS=PCOS*PCOS;
  #declare M2COS=-MCOS*MCOS;

  #declare COS2=COS*COS;
  #declare SIN2=SIN*SIN;

  //
  // the movement pattern
  //
  #declare leftLowerArmAngle  = <  -15,  25*P2SIN    , -30>;
  #declare leftArmAngle       = <   15,  20*COS  +  5, -45>;
  #declare rightLowerArmAngle = <  -15,  25*M2SIN    ,  30>;
  #declare rightArmAngle      = <   15,  20*COS  -  5,  45>;

  #declare rightLowerLegAngle = <  30*M2COS -  5,  0,  0>;
  #declare rightLegAngle      = <  25*SIN   +  5, 15,  0>;
  #declare leftLowerLegAngle  = < -30*P2COS -  5,  0,  0>;
  #declare leftLegAngle       = < -25*SIN   +  5,-15,  0>;

  #declare rightFootAngle     = < -10*SIN, 0, 0>;
  #declare leftFootAngle      = <  10*SIN, 0, 0>;

  #declare headAngle          = <    0,  0,  0>;
  #declare bodyAngle          = <    0,  0,  0>;
#end




#if (playerStanding)
  frameDefaults()
  #declare leftLowerArmAngle  = <  -15,   0, -30>;
  #declare leftArmAngle       = <   15,  10, -45>;
  #declare rightLowerArmAngle = <  -15,   0,  30>;
  #declare rightArmAngle      = <   15, -10,  45>;

  #declare rightLowerLegAngle = < - 25,  0,  0>;
  #declare rightLegAngle      = < + 15, 15,  0>;
  #declare leftLowerLegAngle  = < - 25,  0,  0>;
  #declare leftLegAngle       = < + 15,-15,  0>;

  #declare rightFootAngle     = <    0,  0,  0>;
  #declare leftFootAngle      = <    0,  0,  0>;

  #declare headAngle          = <    0,  0,  0>;
  #declare bodyAngle          = <    0,  0,  0>;
#end

