/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io.inputstream;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import net.lingala.zip4j.io.inputstream.SplitInputStream;
import net.lingala.zip4j.util.FileUtils;

public class NumberedSplitInputStream
extends SplitInputStream {
    public NumberedSplitInputStream(File zipFile, boolean isSplitZipArchive, int lastSplitZipFileNumber) throws FileNotFoundException {
        super(zipFile, isSplitZipArchive, lastSplitZipFileNumber);
    }

    @Override
    protected File getNextSplitFile(int zipFileIndex) throws IOException {
        String currZipFileNameWithPath = this.zipFile.getCanonicalPath();
        String fileNameWithPathAndWithoutExtension = currZipFileNameWithPath.substring(0, currZipFileNameWithPath.lastIndexOf("."));
        return new File(fileNameWithPathAndWithoutExtension + FileUtils.getNextNumberedSplitFileCounterAsExtension(zipFileIndex));
    }
}

