#!/bin/bash

SCRIPT_PATH=$(dirname $0)

cd $SCRIPT_PATH
source _components_to_package.sh

DISABLE_TESTS=0
TEST_ONLY_ONE_PACKAGE_PER_COMPONENT=1

if [ $TEST_ONLY_ONE_PACKAGE_PER_COMPONENT -eq 1 ]; then
    # For BUILD_TOOLS_VERSIONS_TO_PACKAGE we take the 1st and last (because one contains 32bit binary, and the other 64bit binary)
    tmp=$(sort -u <<< $(head -n1 <<< ${BUILD_TOOLS_VERSIONS_TO_PACKAGE}; tail -n1 <<< ${BUILD_TOOLS_VERSIONS_TO_PACKAGE}))
    BUILD_TOOLS_VERSIONS_TO_PACKAGE=$tmp
    unset tmp
    PLATFORMS_VERSIONS_TO_PACKAGE=$(tail -n1 <<< ${PLATFORMS_VERSIONS_TO_PACKAGE})
    CMDLINE_TOOLS_VERSIONS_TO_PACKAGE=$(tail -n1 <<< ${CMDLINE_TOOLS_VERSIONS_TO_PACKAGE})
    PLATFORM_TOOLS_VERSIONS_TO_PACKAGE=$(tail -n1 <<< ${PLATFORM_TOOLS_VERSIONS_TO_PACKAGE})
    NDK_VERSIONS_TO_PACKAGE=$(tail -n1 <<< ${NDK_VERSIONS_TO_PACKAGE})
    EMULATOR_VERSIONS_TO_PACKAGE=$(tail -n1 <<< ${EMULATOR_VERSIONS_TO_PACKAGE})
    EXTRAS_GOOGLE_AUTO_VERSIONS_TO_PACKAGE=$(tail -n1 <<< ${EXTRAS_GOOGLE_AUTO_VERSIONS_TO_PACKAGE})
fi

#Disable test for some packages
#unset BUILD_TOOLS_VERSIONS_TO_PACKAGE
unset PLATFORMS_VERSIONS_TO_PACKAGE
unset CMDLINE_TOOLS_VERSIONS_TO_PACKAGE
unset PLATFORM_TOOLS_VERSIONS_TO_PACKAGE
unset NDK_VERSIONS_TO_PACKAGE
unset EMULATOR_VERSIONS_TO_PACKAGE
#unset EXTRAS_GOOGLE_AUTO_VERSIONS_TO_PACKAGE

# Build debian/tests/control file
mkdir -p ../tests
echo "# -- This file was generated automatically by the debian/scripts/$(basename $0) script --" > ../tests/control

if [ $DISABLE_TESTS -eq 1 ]; then
    # Disable tests to not use bandwith to download the packages
    rm ../tests/control
    exit;
fi

for version in ${BUILD_TOOLS_VERSIONS_TO_PACKAGE}; do
    version=$(echo $version | sed "s/,/;/g")
    VER=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f3)
    VER_MAJOR=$(echo $VER | cut -d . -f 1)
    PATH_DIRNAME=$(dirname $(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f1 | sed "s,;,/,g"))
    PATH_BASENAME=$(basename $(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f1 | sed "s,;,/,g"))

    echo "Test-Command: /usr/lib/android-sdk/$PATH_DIRNAME/$PATH_BASENAME/aapt v" >> ../tests/control
    echo "Depends: google-android-build-tools-$VER-installer" >> ../tests/control

    if [ $VER_MAJOR -le 23 ]; then
        echo "Architecture: i386 amd64" >> ../tests/control
    else
        echo "Architecture: amd64" >> ../tests/control
    fi

    echo "" >> ../tests/control
done

for version in ${PLATFORMS_VERSIONS_TO_PACKAGE}; do
    version=$(echo $version | sed "s/,/;/g")
    VER=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f2)
    VERBIS=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f1 | cut -d ";" -f2 | cut -d "-" -f2 | tr '[:upper:]' '[:lower:]')
    if [ "$VERBIS" != "$VER" ]; then VER="$VER-$VERBIS"; fi
    PATH_DIRNAME=$(dirname $(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f1 | sed "s,;,/,g"))
    PATH_BASENAME=$(basename $(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f1 | sed "s,;,/,g"))

    echo "Test-Command: cat /usr/lib/android-sdk/$PATH_DIRNAME/$PATH_BASENAME/source.properties" >> ../tests/control
    echo "Depends: google-android-platform-$VER-installer" >> ../tests/control
    echo "" >> ../tests/control
done

for version in ${CMDLINE_TOOLS_VERSIONS_TO_PACKAGE}; do
    version=$(echo $version | sed "s/,/;/g")
    VER=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f3)
    PATH_DIRNAME=$(dirname $(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f1 | sed "s,;,/,g"))
    PATH_BASENAME=$(basename $(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f1 | sed "s,;,/,g"))

    echo "Test-Command: /usr/lib/android-sdk/$PATH_DIRNAME/$PATH_BASENAME/bin/sdkmanager --version" >> ../tests/control
    echo "Depends: google-android-cmdline-tools-$VER-installer" >> ../tests/control
    echo "" >> ../tests/control
done

for version in ${PLATFORM_TOOLS_VERSIONS_TO_PACKAGE}; do
    version=$(echo $version | sed "s/,/;/g")
    VER=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f3)
    PATH_DIRNAME=$(dirname $(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f1 | sed "s,;,/,g"))
    PATH_BASENAME=$(basename $(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f1 | sed "s,;,/,g"))

    echo "Test-Command: /usr/lib/android-sdk/$PATH_DIRNAME/$PATH_BASENAME/adb version" >> ../tests/control
    echo "Depends: google-android-platform-tools-installer" >> ../tests/control
    echo "Architecture: amd64" >> ../tests/control
    echo "" >> ../tests/control
done

for version in ${NDK_VERSIONS_TO_PACKAGE}; do
    version=$(echo $version | sed "s/,/;/g")
    VER_LONG=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f3)
    VER=r$(echo $VER_LONG | cut -d . -f 1)$(echo $VER_LONG | cut -d . -f 2 | tr '[1-9]' '[b-z]' | tr -d '0')
    VER_MAJOR=$(echo $VER_LONG | cut -d . -f 1)
    PATH_DIRNAME=$(dirname $(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f1 | sed "s,;,/,g"))
    PATH_BASENAME=$(basename $(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f1 | sed "s,;,/,g"))

    if [ $VER_MAJOR -lt 16 ]; then
        # This works for NDK r10e at least. Not tested for r11 to r15
        echo "Test-Command: \`/usr/lib/android-sdk/$PATH_DIRNAME/$PATH_BASENAME/ndk-which readelf\` -d /usr/lib/android-sdk/$PATH_DIRNAME/$PATH_BASENAME/platforms/android-21/arch-x86/usr/lib/libdl.so" >> ../tests/control
    elif [ $VER_MAJOR -lt 23 ]; then
        echo "Test-Command: \`/usr/lib/android-sdk/$PATH_DIRNAME/$PATH_BASENAME/ndk-which readelf\` -d /usr/lib/android-sdk/$PATH_DIRNAME/$PATH_BASENAME/toolchains/llvm/prebuilt/linux-x86_64/sysroot/usr/lib/i686-linux-android/21/libdl.so" >> ../tests/control
    else
        echo "Test-Command: /usr/lib/android-sdk/$PATH_DIRNAME/$PATH_BASENAME/toolchains/llvm/prebuilt/linux-x86_64/bin/llvm-readobj -d /usr/lib/android-sdk/$PATH_DIRNAME/$PATH_BASENAME/toolchains/llvm/prebuilt/linux-x86_64/sysroot/usr/lib/i686-linux-android/21/libdl.so" >> ../tests/control
    fi
    echo "Depends: google-android-ndk-$VER-installer" >> ../tests/control
    echo "Architecture: amd64" >> ../tests/control
    echo "" >> ../tests/control
done

for version in ${EMULATOR_VERSIONS_TO_PACKAGE}; do
    version=$(echo $version | sed "s/,/;/g")
    VER=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f3)
    PATH_DIRNAME=$(dirname $(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f1 | sed "s,;,/,g"))
    PATH_BASENAME=$(basename $(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f1 | sed "s,;,/,g"))

    echo "Test-Command: emulator -help" >> ../tests/control
    echo "Depends: google-android-emulator-installer" >> ../tests/control
    echo "Architecture: amd64" >> ../tests/control
    echo "" >> ../tests/control
done

for version in ${EXTRAS_GOOGLE_AUTO_VERSIONS_TO_PACKAGE}; do
    version=$(echo $version | sed "s/,/;/g")
    VER=$(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f3)
    PATH_DIRNAME=$(dirname $(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f1 | sed "s,;,/,g"))
    PATH_BASENAME=$(basename $(grep --perl-regex "^$version\t" ../version_list.txt | cut -d "	" -f1 | sed "s,;,/,g"))

    echo "Test-Command: /usr/lib/android-sdk/$PATH_DIRNAME/$PATH_BASENAME/desktop-head-unit --version" >> ../tests/control
    echo "Depends: google-android-extras-google-auto-installer" >> ../tests/control
    echo "Architecture: amd64" >> ../tests/control
    echo "" >> ../tests/control

done
