/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMember;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.editor.AttributesEditor;
import proguard.classfile.editor.ClassEditor;
import proguard.classfile.editor.CodeAttributeComposer;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.CodeAttributeEditorResetter;
import proguard.classfile.editor.CompactCodeAttributeComposer;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.util.ClassSubHierarchyInitializer;
import proguard.classfile.util.ClassSuperHierarchyInitializer;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ConstructorMethodFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MethodCollector;
import proguard.obfuscate.NameFactory;
import proguard.obfuscate.UniqueMemberNameFactory;

public class SimplifiedClassEditor
extends SimplifiedVisitor
implements AttributeVisitor {
    private static final String EXTRA_INIT_METHOD_NAME = "init$";
    private static final String EXTRA_INIT_METHOD_DESCRIPTOR = "()V";
    private final ProgramClass programClass;
    private final ClassEditor classEditor;
    private final ConstantPoolEditor constantPoolEditor;
    private final NameFactory nameFactory;
    private String superClassName;
    private final List<CodeComposer> methodComposers = new ArrayList<CodeComposer>();
    private Instruction[] instructions;

    public SimplifiedClassEditor(int n, String string) {
        this(n, string, null);
    }

    public SimplifiedClassEditor(int n, String string, String string2) {
        this(new ProgramClass(0x2E0000, 1, new Constant[10], n, 0, 0));
        this.programClass.u2thisClass = this.constantPoolEditor.addClassConstant(string, this.programClass);
        if (string2 != null) {
            this.programClass.u2superClass = this.constantPoolEditor.addClassConstant(string2, null);
            this.superClassName = string2;
        }
    }

    public SimplifiedClassEditor(ProgramClass programClass) {
        this.programClass = programClass;
        this.classEditor = new ClassEditor(programClass);
        this.constantPoolEditor = new ConstantPoolEditor(programClass);
        this.nameFactory = UniqueMemberNameFactory.newInjectedMemberNameFactory(programClass);
    }

    public void finishEditing() {
        for (CodeComposer codeComposer : this.methodComposers) {
            codeComposer.finishEditing();
        }
    }

    public void finishEditing(ClassPool classPool, ClassPool classPool2) {
        for (CodeComposer codeComposer : this.methodComposers) {
            codeComposer.finishEditing();
        }
        if (this.superClassName != null) {
            new ClassSuperHierarchyInitializer(classPool, classPool2, null, null).visitProgramClass(this.programClass);
            new ClassSubHierarchyInitializer().visitProgramClass(this.programClass);
        }
        new ClassReferenceInitializer(classPool, classPool2).visitProgramClass(this.programClass);
    }

    public ProgramClass getProgramClass() {
        return this.programClass;
    }

    public int addClassConstant(String string, Clazz clazz) {
        return this.constantPoolEditor.addClassConstant(string, clazz);
    }

    public SimplifiedClassEditor addField(int n, String string, String string2) {
        ProgramField programField = new ProgramField(n, this.constantPoolEditor.addUtf8Constant(string), this.constantPoolEditor.addUtf8Constant(string2), null);
        this.classEditor.addField(programField);
        return this;
    }

    public CompactCodeAttributeComposer addMethod(int n, String string, String string2, int n2) {
        return this.addMethod(n, string, string2, null, n2);
    }

    public CompactCodeAttributeComposer addMethod(int n, String string, String string2, Clazz[] clazzArray, int n2) {
        ProgramMethod programMethod = new ProgramMethod(n, this.constantPoolEditor.addUtf8Constant(string), this.constantPoolEditor.addUtf8Constant(string2), clazzArray);
        CodeComposer codeComposer = new CodeComposer(programMethod, n2);
        this.methodComposers.add(codeComposer);
        return codeComposer;
    }

    public ProgramMethod addMethod(int n, String string, String string2, Instruction[] instructionArray) {
        return this.addMethod(n, string, string2, instructionArray, null, null);
    }

    public void addStaticInitializerInstructions(Instruction[] instructionArray, boolean bl) {
        Method method = this.programClass.findMethod("<clinit>", EXTRA_INIT_METHOD_DESCRIPTOR);
        if (method == null) {
            this.addMethod(8, "<clinit>", EXTRA_INIT_METHOD_DESCRIPTOR, instructionArray, null, new SimpleInstruction(-79));
        } else {
            Object object;
            if (!bl) {
                object = this.addMethod(8, this.nameFactory.nextName(), EXTRA_INIT_METHOD_DESCRIPTOR, instructionArray, null, new SimpleInstruction(-79));
                InstructionSequenceBuilder instructionSequenceBuilder = new InstructionSequenceBuilder(this.programClass);
                instructionSequenceBuilder.invokestatic(this.programClass.getName(), ((ProgramMember)object).getName(this.programClass), EXTRA_INIT_METHOD_DESCRIPTOR, this.programClass, (Member)object);
                instructionArray = instructionSequenceBuilder.instructions();
            }
            object = new CodeAttributeEditor();
            ((ProgramMethod)method).attributesAccept(this.programClass, new CodeAttributeEditorResetter((CodeAttributeEditor)object));
            ((CodeAttributeEditor)object).insertBeforeOffset(0, instructionArray);
            ((ProgramMethod)method).attributesAccept(this.programClass, (AttributeVisitor)object);
        }
    }

    public void addInitializerInstructions(Instruction[] instructionArray) {
        Method method = this.programClass.findMethod("<init>", null);
        if (method == null) {
            Instruction[] instructionArray2 = new Instruction[]{new VariableInstruction(42), new ConstantInstruction(-73, this.constantPoolEditor.addMethodrefConstant(this.programClass.getSuperClass().getName(), "<init>", EXTRA_INIT_METHOD_DESCRIPTOR, null, null))};
            SimpleInstruction simpleInstruction = new SimpleInstruction(-79);
            this.addMethod(1, "<init>", EXTRA_INIT_METHOD_DESCRIPTOR, instructionArray, instructionArray2, simpleInstruction);
        } else {
            HashSet<Method> hashSet = new HashSet<Method>();
            this.programClass.methodsAccept(new ConstructorMethodFilter(new MethodCollector(hashSet), null, null));
            if (hashSet.size() == 1) {
                this.instructions = instructionArray;
                ((Method)hashSet.iterator().next()).accept(this.programClass, new AllAttributeVisitor(this));
            } else {
                ProgramMethod programMethod = (ProgramMethod)this.programClass.findMethod(EXTRA_INIT_METHOD_NAME, EXTRA_INIT_METHOD_DESCRIPTOR);
                if (programMethod == null) {
                    programMethod = this.addMethod(2, EXTRA_INIT_METHOD_NAME, EXTRA_INIT_METHOD_DESCRIPTOR, instructionArray, null, new SimpleInstruction(-79));
                    InstructionSequenceBuilder instructionSequenceBuilder = new InstructionSequenceBuilder(this.programClass);
                    instructionSequenceBuilder.aload_0();
                    instructionSequenceBuilder.invokespecial(this.programClass.getName(), EXTRA_INIT_METHOD_NAME, EXTRA_INIT_METHOD_DESCRIPTOR, this.programClass, programMethod);
                    this.instructions = instructionSequenceBuilder.instructions();
                    this.programClass.methodsAccept(new ConstructorMethodFilter(new AllAttributeVisitor(this), null, null));
                } else {
                    this.instructions = instructionArray;
                    programMethod.accept(this.programClass, (MemberVisitor)new AllAttributeVisitor(this));
                }
            }
        }
    }

    private ProgramMethod addMethod(int n, String string, String string2, Instruction[] instructionArray, Instruction[] instructionArray2, Instruction instruction) {
        ProgramMethod programMethod = new ProgramMethod(n, this.constantPoolEditor.addUtf8Constant(string), this.constantPoolEditor.addUtf8Constant(string2), null);
        CodeAttribute codeAttribute = new CodeAttribute(this.constantPoolEditor.addUtf8Constant("Code"));
        CodeAttributeComposer codeAttributeComposer = new CodeAttributeComposer();
        codeAttributeComposer.reset();
        codeAttributeComposer.beginCodeFragment(0);
        codeAttributeComposer.appendInstructions(instructionArray);
        if (instructionArray2 != null) {
            for (Instruction instruction2 : instructionArray2) {
                codeAttributeComposer.appendInstruction(instruction2);
            }
        }
        if (instruction != null) {
            codeAttributeComposer.appendInstruction(instruction);
        }
        codeAttributeComposer.endCodeFragment();
        codeAttributeComposer.visitCodeAttribute(this.programClass, programMethod, codeAttribute);
        new AttributesEditor(this.programClass, programMethod, false).addAttribute(codeAttribute);
        this.classEditor.addMethod(programMethod);
        return programMethod;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();
        ((ProgramMethod)method).attributesAccept(this.programClass, new CodeAttributeEditorResetter(codeAttributeEditor));
        codeAttributeEditor.insertBeforeOffset(0, this.instructions);
        codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
    }

    private class CodeComposer
    extends CompactCodeAttributeComposer {
        private final ProgramMethod method;

        public CodeComposer(ProgramMethod programMethod, int n) {
            super(SimplifiedClassEditor.this.programClass);
            this.method = programMethod;
            this.beginCodeFragment(n);
        }

        public void finishEditing() {
            this.endCodeFragment();
            CodeAttribute codeAttribute = new CodeAttribute(SimplifiedClassEditor.this.constantPoolEditor.addUtf8Constant("Code"));
            this.visitCodeAttribute(SimplifiedClassEditor.this.programClass, this.method, codeAttribute);
            new AttributesEditor(SimplifiedClassEditor.this.programClass, this.method, false).addAttribute(codeAttribute);
            SimplifiedClassEditor.this.classEditor.addMethod(this.method);
        }
    }
}

